#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# ParserTypes.py
#
# DESCRIPTION:
# Universal Report-specific Parser types
#
# NOTES:
#
############################################################
#
# Used by GParser XmlElements
#

__all__ = [ 'measurement', 'fixedmeasurement', 'textmeasurement',
            'color', 'percentage' ]

from gnue.common.datatypes.Color import Color

from Helpers.Measurement import Measurement
from Helpers.TextMeasurement import TextMeasurement

def measurement(value):
  return Measurement(value, allowAuto=1)

def fixedmeasurement(value):
  return Measurement(value, allowAuto=0)

def textmeasurement(value):
  return TextMeasurement(value, allowAuto=1)

def color(value):
  return Color(value)

def percentage(value):
  if value[-1:] == '%':
    return float(value[:-1]) /100
  else:
    return float(value)
