#
# Copyright 2002-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# Set of classes that provide a menuing interface via wxPython's
# wxHtml* classes.  This provides a themed menuing interface.
#
# NOTES:
# Experimental, at best.


from wxPython.wx import *
from wxPython.html import *
from gnue.forms.uidrivers import wx as ui
 
class Instance(wxApp):
  def __init__(self, processes):
    self.processes = processes
    wxApp.__init__(self)

  def run(self, connections):
    self.connections = connections
    #
    # Assign the proper login handler based upon the user interface choice
    #
    self.connections.setLoginHandler(ui.UILoginHandler())

    self.MainLoop()

  def OnInit(self):

    self.frame = wxFrame(NULL, -1, "Nothing")
    EVT_CLOSE(self.frame,self.OnClose)
    self.frame.Show(true)
    self.htmlpanel = MyHtmlWindow(self, self.frame, -1)#, style=wxHW_SCROLLBAR_NEVER)
    self.buildMenu(self.processes)
    return 1


  def OnClose(self, event):
    self.frame.Destroy()

  def buildMenu(self, process):

    self.selections = {}
    html = self.getHtmlHeader()

    for child in process._children:

      if child._type == 'GNProcess':
        url = '%s' % id(child)
        text = child.title
        html += self.getHtmlMenu(url, text)

      elif child._type == 'GNStep':
        url = '%s' % id(child)
        html += self.getHtmlStep(url, child.title, child.type)

      self.selections['%s' % id(child)] = child

    self.frame.SetTitle(process._type == 'GNProcesses' and process.title or \
                        process.title)
    
    # if this is not the top branch
    if process!=self.processes:

      url = '%s' % id(process._parent)
      html += self.getHtmlBack(url, process._parent.title, \
                               process._parent._type)
      self.selections['%s' % id(process._parent)] = process._parent

    html += self.getHtmlFooter()

    self.htmlpanel.SetPage(html)


  def OnLinkClicked(self, event):
    self.beginWait()
    object = self.selections[event.GetHref()]
    if object._type == 'GNStep':
      object.run()
    else:
      self.buildMenu(object)
    self.endWait()

  #
  # Default HTML Template
  #

  def getHtmlHeader(self):
    self.shading = 0
    return """
<html><body>
<table width="100%">
"""


  def getHtmlFooter(self):
    return """
</table>
</body></html>
"""


  def getHtmlMenu(self, url, description):
    if self.shading:
      shade = ' bgcolor="#EEEEEE"'
    else:
      shade = ""

    self.shading = not self.shading

    return """
<tr%s><td><b><a href="%s">%s</a></b></td></tr>
""" % (shade, url, description)


  def getHtmlStep(self, url, description, type):
    if self.shading:
      shade = ' bgcolor="#EEEEEE"'
    else:
      shade = ""

    self.shading = not self.shading

    return """
<tr%s><td><a href="%s">%s</a></td></tr>
""" % (shade,url, description)

  
  def getHtmlBack(self, url, description, type):
    if self.shading:
      shade  = ' bgcolor="#EEEEEE"'
      shadeA = ""
    else:
      shade  = ""
      shadeA = ' bgcolor="#EEEEEE"'

    self.shading = not self.shading

    return """
<tr%s><td>&nbsp;</td></tr>    
<tr%s><td><font size=-1><a href="%s">[back to <i>%s</i>]</a></font></td></tr>
""" % (shade,shadeA,url, description)

  # Called whenever forms goes into a "wait" state in which user cannot
  # interact with interface (e.g., while waiting for a query or a commit)
  def beginWait (self):
    wxBeginBusyCursor()

  # Called whenever forms leaves a "wait" state
  def endWait (self):
    wxEndBusyCursor()




class MyHtmlWindow(wxHtmlWindow):
  def __init__(self, instance, *args, **params):
    self.instance = instance
    wxHtmlWindow.__init__(self, *args, **params)

  def OnLinkClicked(self, linkinfo):
#    print "Something happened"
    self.instance.OnLinkClicked(linkinfo)

