#
# Copyright 2002-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# gnome-menu.py
#
# DESCRIPTION:
# Install a GNOME menu structure based on a GPD file
#
# NOTES:
# Optional parameters:
#   system[="/path/to/gnomedir]   -- Install system-wide (needs root access)
#
#   menu="Menu/Structure"       -- Menu structure... by default,
#                                  "GNUe Apps/" + the to process's description
#   quiet                       -- Turn on quiet mode
#

import string, sys, os


def run(processes, args):

  print "Creating GNOME menu structure.."

  arguments = {}
  for argument in args:
    if '=' in argument:
      param, value = string.split(argument,'=',1)
    else:
      param, value = (argument, "")

  directory = "~/.gnome2/vfolders/applications/"

  if arguments.has_key('menu'):
    directory = os.path.join(directory,arguments['menu'])
  else:
    directory = os.path.join(directory,'GNUe Apps')

  directory = os.path.expanduser(directory)

  buildMenu(processes, directory)



def buildMenu(process, location):

# add this assignment as otherwise undeclared variable errors crop up
# need to be able to build "directory" before building steps
  description = ""
  
# couldn't get this line to work quite right wasn't sure of the python
# syntax i believe adding parens around process.title or process.description
# might fix it, but broke it into something simpler because of my unsuredness

#  description = process._type == 'GNProcesses' and process.title or process.description
  if process._type == 'GNProcesses':
    description = process.title or process.description

  directory = os.path.join(location, string.replace(description,'/',''))
  if not os.path.exists(directory):
    os.makedirs(directory)

# this is the section that needs gutting for gnome2  as they have massively
# changed how to do this.  They now use vfolders.  There is a tutorial
# found here http://www.gnome.org/start/2.0/menuediting.html
  outfile = open(os.path.join(directory,'.directory'),'w')
  outfile.write("""[Desktop Entry]
Name=%s
Icon=gnome-folder.png
Terminal=false
MultipleArgs=false
Type=Directory
""" % description)

  for child in process._children:

    if child._type == 'GNStep':
      makeLinkFile(directory, child)
    else:
      buildMenu(child, directory)


def makeLinkFile(directory, step):

# changed step.description to step.title as description seemed invalid
  outfile=open(os.path.join(
      directory,string.replace(step.title,"/","") + \
      '.desktop'),'w')

# these two "run commands" have changed, didn't take time to find new names
  if step.type == 'form':
    command = "fixme" #gConfig("RunFormCommand")
    icon = "gnome-applications.png"
  elif step.type == 'report':
    command = "fixme" #gConfig("RunReportCommand")
    icon = "gnome-note.png"

# updated to gnome2 style .desktop entry
  outfile.write("""\
[Desktop Entry]
Version=AddLater
Encoding=UTF-8
Type=Application
Exec=%(executable)s %(location)s
Icon=%(icon)s
Terminal=false
Name=%(description)s
Comment=%(description)s
TerminalOptions=
MultipleArgs=false
""" % { 'executable': command,
        'icon': icon,
        'description': step.title,
        'location': step.location })

  outfile.close()



