#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# win32/widgets/button.py
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32gui, win32con

from gnue.common import events
from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Button
from gnue.forms.uidrivers.win32.common import *

#
# UIButton
#
# Widget set specific function that creates a single instance of a button
#
class UIButton(UIHelper):
  def _createWidget(self, event, spacer):
    object = event.object
    style = win32con.BS_PUSHBUTTON | win32con.WS_CHILD
    styleEx = 0
    newWidget = Win32Button(self._uiDriver, styleEx, 'BUTTON', textEncode(object.label), style,
                        object.Char__x*event.widgetWidth,
                        (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight, 
                        object.Char__width*event.widgetWidth+8,
                        object.Char__height*event.widgetHeight,
                        event.container, getNextId())
    if event.initialize:
      self._eventHandler = event.eventHandler
      event.container.Connect(newWidget.GetId(), self.buttonHandler)

    return newWidget

  def buttonHandler(self, id):
      action = None
      gfObject = self._uiDriver._IdToGFObj[id]
      action = events.Event('buttonActivated',gfObject)
      self._eventHandler(action)

configuration = {
    'baseClass'  : UIButton,
    'provides'   : 'GFButton',
    'container'  : 0,
    }
