#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# win32/widgets/box.py
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#
import win32gui, win32con

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import *

#
# UIBox
#
# Widget set specific function that creates a single instance of a border box
#
class UIBox(UIHelper):
    
  def _createWidget(self, event, spacer):

    object = event.object
    style = win32con.WS_CHILD | win32con.BS_GROUPBOX | win32con.WS_GROUP 
    styleEx = 0
    newWidget = Win32Window(self._uiDriver, styleEx, 'BUTTON', textEncode(object.label), style,
                       object.Char__x*event.widgetWidth+(event.widgetWidth/2),
                       (object.Char__y+spacer+(spacer*object._gap))*event.widgetHeight+(event.widgetHeight/2),
                       (object.Char__width-1)*event.widgetWidth,
                       (object.Char__height-1)*event.widgetHeight,
                       event.container)
    return newWidget


#
# Configuration data 
#
configuration = {
    'baseClass'  : UIBox,
    'provides'   : 'GFBox',
    'container'  : 0,
    }

