#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# gtk2/UILoginHandler.py
#
# DESCRIPTION:
# Part of the gtk2 based user interface driver for GNUe forms.
#
# NOTES:
#

import string
import os.path

import gtk

from gnue.common.datasources import GLoginHandler
from gnue.common.apps import GConfig

# Shortcut
images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'


#####################################################################
##
## Login Support
##
#####################################################################

class UILoginHandler(GLoginHandler.LoginHandler):
  def __init__(self):
    self.dlg = None

  # Hack for McMillan packaging on win32
  # TODO: do we need that?
  def getDummyLogin(self):
    pass

  def getLogin(self, loginData, errortext=None):
    
    if len(loginData[1]):
      loginMesg = _('Login required for\n"%s"') % (loginData[1])
    else:
      loginMesg = _('Login required for %s') % (loginData[0])
      
    self.dlg = gtk.Dialog(_("GNU Enterprise: Login to %s") % loginData[0],
                          None, gtk.DIALOG_MODAL,
                          (_("_LOGIN"), gtk.RESPONSE_OK,
                           _("_CANCEL"), gtk.RESPONSE_CANCEL))
    
    table1 = gtk.Table(len(loginData[2])+10, 6) # row, column
    table1.set_row_spacings(4)
    table1.set_col_spacings(4)
    
    bmp = gtk.Image()
    
    if os.path.isabs(gConfigForms('loginPNG')):
      imageFile = gConfigForms('loginPNG')
    else:
      imageFile = images_dir+gConfigForms('loginPNG')
      
    bmp.set_from_file(imageFile)
    table1.attach(bmp,1,3,0,1)
    
    messageField = gtk.Label(str(loginMesg))
    table1.attach(messageField,1,3,2,3)
    
    self.textEntryList = []
    labelList = []

    for prompt in loginData[2]:
        
      # Build label
      s = gtk.Label('%s:' % prompt[1])
      s.set_use_underline(gtk.TRUE)
      labelList.append(s)

      # Build entry fields
      t = gtk.Entry()

      # set visibility to 0 for password fields
      if prompt[2]:
        t.set_visibility(0)
        
      myID = len(self.textEntryList)
      self.textEntryList.append(t)
      t.connect("key-press-event", self.keyPressHandler, myID)

    num_rows=len(loginData[2])
      
    # Add labels and entry fields to layout

    for i in range(0, len(self.textEntryList)):
      table1.attach(labelList[i],1,2,i+3,i+4)
      table1.attach(self.textEntryList[i],2,3,i+3,i+4)

    if errortext:
      errorField = gtk.Label(str(errortext))
      errorField.set_line_wrap(gtk.TRUE)
      # Write in errortext in red
      errorField.modify_fg(gtk.STATE_NORMAL,gtk.gdk.color_parse('red'))
      
      t = len(self.textEntryList)
      table1.attach(errorField,1,3,t+4,t+5)

    # focus first entry
    self.textEntryList[0].grab_focus()

    self.dlg.vbox.pack_start(table1, gtk.TRUE, gtk.TRUE, 0)
    self.dlg.set_position(1)  #for center
    self.dlg.show_all()

    response=self.dlg.run()

    self.dlg.destroy()
      
    if response==gtk.RESPONSE_OK:
      self.loginCompleted(1)
    else:
      self.loginCompleted(0)
      raise GLoginHandler.UserCanceledLogin

    # get loginData
    rv = {}
    for i in range(0, len(loginData[2])):
      rv[loginData[2][i][0]] = self.textEntryList[i].get_text()

    return rv

  #
  # Login is completed, for whatever reason
  #
  def loginCompleted(self, successful):
    self._completed = successful

  #
  # Called when user presses a key
  #     -- interupts event chain, if ENTER was pressed
  #
  def keyPressHandler(self, widget, event, myID):
    if event.type!=gtk.gdk.KEY_PRESS:
      return

    # Check if ENTER is pressed:
    if event.keyval == gtk.keysyms.Return and \
       not event.state:

      try:
        # move to next Entry in List
        self.textEntryList[myID+1].grab_focus()
      except IndexError:
        # for the last event in the list, trigger OK button
        self.dlg.response(gtk.RESPONSE_OK)
