#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

from gnue.common.cursing import *
from gnue.forms.uidrivers.curses.widgets._base import UIHelper

from gnue.forms.uidrivers.curses.GFsio import *

import wrappers
import string

#
# UIForm
#
# Widget set specific function that creates a single instance of a Form widget
#
class UIForm(UIHelper):
  tabStyles = {'top':0,
               'left':1,
               'right':2,
               'bottom':3,
               }

  def _createWidget(self, event, spacer):
    object = event.object
    gDebug(0, "OBJECT %s"% object)
    #import sys
    #sys.exit()

    SIO = GetSIO()  # get handle to the existing screen interface object
    
    self.mainWindow = ScreenContainer(SIO)
    self.containerFrame = self.mainWindow
    
    # The window in which pages will be rendered
    if object._layout.tabbed != 'none':
      self._wrapper = wrappers.TabbedWrapper(self)
  
    else:
      self._wrapper = wrappers.PlainWrapper(self)    
    
    newWidget = self._wrapper.pane


    self._containerToolkitWidget = newWidget


    # Add the menu
    menu = {'file':[ {'id'   :100,
                      'text' :'Commit     (F6)',
                      'tip'  : "gConfigForms('msg_commit')",
                      'event':'requestCOMMIT'},
                     {'id'   :102,
                      'text' :'Rollback  (F11)',
                      'tip'  : "gConfigForms('msg_rollback')",
                      'event':'requestROLLBACK'},
                     {'id': -1,'text': None, 'tip': None, 'event':None},
                     {'id'   :104,
                      'text' :'Print          ',
                      'tip'  : "gConfigForms('msg_print')",
                      'event':'requestPRINTOUT'},
                     {'id'   :101,
                      'text' :'Exit           ',
                      'tip'  : "gConfigForms('msg_exit')",
                      'event':"self.menuExitEvent"},
                     ],
            'edit':[ {'id'   :401,
                      'text' :'Cut',
                      'tip'  :'Cut the selected text',
                      'event':'requestCUT'},
                     {'id'   :402,
                      'text' :'Copy',
                      'tip'  : "Copy the selected text",
                      'event':'requestCOPY'},
                     {'id'   :403,
                      'text' :'Paste',
                      'tip'  : "Paste the selected text",
                      'event':'requestPASTE'},
                                          ],
            'data':[ {'id'   :201,
                      'text' :'Next Record',
                      'tip'  :"gConfigForms('msg_next')",
                      'event':'requestNEXTRECORD'},
                     {'id'   :202,
                      'text' :'Previous Record',
                      'tip'  :"gConfigForms('msg_previous')",
                      'event':'requestPREVRECORD'},
                     {'id'   :209,
                      'text' :'Jump to Record...',
                      'tip'  :"gConfigForms('msg_jump')",
                      'event':'self.promptForRecordNumber'},
                     {'id': -1,'text': None, 'tip': None, 'event':None},
                     {'id'   :204,
                      'text' :'Delete Record          (F5)',
                      'tip'  :"gConfigForms('msg_delete')",
                      'event':'requestMARKFORDELETE'},
                     {'id'   :205,
                      'text' :'Next Block           (PgDn)',
                      'tip'  :"gConfigForms('msg_next_block')",
                      'event':'requestNEXTBLOCK'},
                     {'id'   :206,
                      'text' :'Previous Block       (PgUp)',
                      'tip'  :"gConfigForms('msg_previous_block')",
                      'event':'requestPREVBLOCK'},
                     {'id': -1,'text': None, 'tip': None, 'event':None},
                     {'id'   :207,
                      'text' :'Enter Query            (F8)',
                      'tip'  :"gConfigForms('msg_query_prep')",
                      'event':'requestENTERQUERY'},
                     {'id'   :208,
                      'text' :'Execute Query        (F9)',
                      'tip'  :"gConfigForms('msg_query')",
                      'event':'requestEXECQUERY'},
                                          ],

            'help':[ {'id'   :301,
                      'text' :'About...',
                      'tip'  :"gConfigForms('msg_help')",
                      'event':'requestAbout'},
                                          ],
                        }

    menuBar = MenuBar(self.mainWindow,0,0, self._uiDriver._screen.MAXCOL)

    for _menu in ['file','edit','data','help']:
      newMenu=menuBar.NewMenu(_menu,_menu.capitalize())
      for menuitem in menu[_menu]:
        if menuitem['id'] > 0:
          newMenu.AddItem(menuitem['id'],menuitem['text'])
        else:
          newMenu.InsertSeperator()
      newMenu.Finalize()


    # The status bar
    self.statusBar = StatusBar(self.mainWindow, "StatusBar",
                                 self._uiDriver._screen.MAXROW, 0,self._uiDriver._screen.MAXCOL, (-1,4,3,9,5))

    self.statusBar.SetText(0,'Welcome to GNUe Forms')
    self.statusBar.SetText(1,'OK')
    self.statusBar.SetText(2,'INS')
    self.statusBar.SetText(3,'0/0')
    self.statusBar.SetText(4,'1/1')

    #    self.mainWindow.AddControl(menuBar)
    self.mainWindow.AddControl(self.statusBar)
    self.mainWindow.Paint()

    return newWidget


##    newWidget = Dialog(event.container, 0, 0, event.interface._screen.MAXROW, event.interface._screen.MAXCOL )

##    return newWidget

  def _setStatusBar(self,tip, statusValue, insertValue, currentRecord, maxRecord, currentPage, maxPage):
    if tip != None: self.statusBar.SetText(0,str(tip))

    if statusValue:
      self.statusBar.SetText(1,statusValue)

    if insertValue:
      self.statusBar.SetText(2,insertValue)

    if currentRecord and  maxRecord:
      self.statusBar.SetText(3,string.strip("%s/%s" % (currentRecord,maxRecord)))

    if currentPage and  maxPage:
      self.statusBar.SetText(4,string.strip("%s/%s" % (currentPage,maxPage)))


#
# Configuration data
#
configuration = {
  'baseClass'  : UIForm,
  'provides'   : 'GFForm',
  'container'  : 1,
  }
