#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# _base.py
#
# DESCRIPTION:
# Provides UIHelper, a UI widget set of std functions to reduce the
# number of functions require in each individual UIclass
#
# NOTES:
#

from gnue.common.cursing import *

from gnue.forms.GFForm import *
from gnue.forms.uidrivers._base.widgets._base import *
from gnue.common import events


class UIHelper(UIWidget):
  def showModal(self):
    pass # self.ShowModal()

  def show(self, flag=1):
    pass # self.Show(flag)

  def destroy(self):
    pass # self.Destroy()

  def indexedFocus(self, index):
    GDebug.printMesg(0, "Widget list %s" % self.widgets)
    GDebug.printMesg(0, "Index %s" % index)
    widget = self.widgets[index]
    widget.PARENT.SetFocus(widget,run=False)

  def setValue(self, value, index=0, enabled=True):
    self.widgets[index].SetValue(value)

  def setCursorPosition(self, position, index=0):
    try:
      self.widgets[index].SetCursor(position)
    except AttributeError:
      pass

  def setSelectedArea(self, selection1, selection2, index=0):
    pass

  def _addToCrossRef(self, widget,gfobject, uiobject):
    pass


  def createWidget(self, event, spacer):
    newWidget = self._createWidget(event, spacer)
    self._addToCrossRef(newWidget,event.object,self)
    return newWidget
