#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

import os
import sys
import string

import curses
from gnue.common.cursing import *

from gnue.common import events

from gnue.forms.GFForm import *

from gnue.forms.uidrivers._commonGuiToolkit import UIdriver as commonToolkit
#from gnue.forms.uidrivers.curses.common import _EVENTPROCESSOR

from gnue.common.apps import GDebug
from gnue.common.datasources import GLoginHandler
from gnue.common.utils.TextUtils import lineWrap

_NOTEBOOK = None
_LOOPTRAP = 0
_EVENTPROCESSOR = None
_charWidth = 0
_IdToTkObj = {}
_IdToGFObj = {}
_IdToUIObj = {}

#

_SIO = None

def GetSIO():
  global _SIO
  if not _SIO:
    _SIO = sio()
    _SIO.BeginScreenAccess()
    atexit.register(_restore)
  return _SIO

def _restore(*args, **parms):
  # Set everything back to normal
  try:
#    _SIO.keypad(0)
    curses.echo()
    curses.nocbreak()
    curses.endwin()          # Terminate curses
  except:
    pass


#####################################################################
##
## Basic Event Processing
##
#####################################################################

def _setDefaultEventHandlers(newWidget, initialize):
  global _EVENTPROCESSOR
  if initialize:
    newWidget.SetMethod("CLICK", mouseEvtHandler(_EVENTPROCESSOR))


class uiBaseEvtHandler:
  def __init__(self,eventList,eventProcessor):
    pass
##     wxEvtHandler.__init__(self)
##     self._eventProcessor = eventProcessor
##     for eventType in eventList:
##       self.Connect(-1, -1, eventType,self._processEvent)

##   def _processEvent(self,a1, a2, a3):
##     GDebug.printMesg(0,"uiBaseEvtHandler _processEvent was called?!?")

class mouseEvtHandler(uiBaseEvtHandler):
  def __init__(self,eventProcessor):
    pass
##     eventList = [wxEVT_LEFT_DOWN]
##     uiBaseEvtHandler.__init__(self, eventList, eventProcessor)

##   def _processEvent(self,event):
##     global _charWidth
##     object = _eventObjTowxWindow(event)

##     # compute the location of the character in the widget
##     x,y = event.GetPosition()
##     cursorPosition = 1 + x/_charWidth

##     # Move to proper object
##     id = object.GetId()
##     gfObject     = _IdToGFObj[id]
##     screenWidget = _IdToTkObj[id]
##     count        = _IdToUIObj[id].widgets.index(screenWidget)
##     self._eventProcessor(events.Event('requestFOCUS',gfObject))
##     self._eventProcessor(events.Event('requestJUMPRECORD',count - gfObject._visibleIndex))
##     self._eventProcessor(events.Event('requestCURSORMOVE',position=cursorPosition))

##     event.Skip()

class keyboardEvtHandler(uiBaseEvtHandler):
  def __init__(self, eventProcessor):
    self._eventProcessor = eventProcessor
    uiBaseEvtHandler.__init__(self, [], eventProcessor)

  def _processEvent(self, keystroke):
    ####return keystroke
    action = None

    ##object = _eventObjTowxWindow(event)

    
    gDebug(0,"key====== %s" % keystroke)
    command = GFKeyMapper.KeyMapper.getEvent(
        keystroke,
        0, #event.ShiftDown(),
        0, #event.ControlDown(),
        0) #event.AltDown())

    gDebug(0,"========= %s" % command)

      # TODO : Broken for the moment, this should probably be form driven
      #if command == 'JUMPRECORD':
      #  self.promptForRecordNumber()

    if command:
      action = events.Event('request%s' % command)

    else:
      try:
        GDebug.printMesg(1,'Keystroke=(%s,%s)' % (keystroke, chr(keystroke)))
        if 32 <= keystroke <= 255 and chr(keystroke) in string.printable:
          GDebug.printMesg(1,'Keystroke is printable')
          action = events.Event('requestKEYPRESS', chr(keystroke),
                         text=chr(keystroke),
                         code=keystroke)
      except ValueError:
        pass

    if action:
      # Add the object's _form to the outgoing event
      # rather than every event in the function
      action.__dict__.update({'_form':self._form})

            
      self._eventProcessor(action)

    return None

#####################################################################
##
## Keymapper Support
##
#####################################################################
from gnue.forms import GFKeyMapper
from gnue.forms.GFKeyMapper import vk

# Translate from curses keystrokes to our virtual keystrokes
cursesKeyTranslations = {
  vk.F1        : curses.KEY_F1,        vk.F2       : curses.KEY_F2,
  vk.F3        : curses.KEY_F3,        vk.F4       : curses.KEY_F4,
  vk.F5        : curses.KEY_F5,        vk.F6       : curses.KEY_F6,
  vk.F7        : curses.KEY_F7,        vk.F8       : curses.KEY_F8,
  vk.F9        : curses.KEY_F9,        vk.F10      : curses.KEY_F10,
  vk.F11       : curses.KEY_F11,       vk.F12      : curses.KEY_F12,
  vk.INSERT    : curses.KEY_IC,        vk.DELETE   : curses.KEY_DC,
  vk.HOME      : curses.KEY_HOME,      vk.END      : curses.KEY_END,
  vk.PAGEUP    : curses.KEY_PPAGE,     vk.PAGEDOWN : curses.KEY_NPAGE,
  vk.UP        : curses.KEY_UP,        vk.DOWN     : curses.KEY_DOWN,
  vk.LEFT      : curses.KEY_LEFT,      vk.RIGHT    : curses.KEY_RIGHT,
  vk.TAB       : 9,                    vk.ENTER    : 10,
  vk.BACKSPACE : curses.KEY_BACKSPACE }


GFKeyMapper.KeyMapper.setUIKeyMap(cursesKeyTranslations)







