#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A curses based user interface driver for GNUe forms.
#
# NOTES:
#

import os
import sys
import string

import atexit
import curses
from gnue.common.cursing import *

from gnue.common import events

from gnue.forms.GFForm import *

from gnue.forms.uidrivers._commonGuiToolkit import UIdriver as commonToolkit
from gnue.forms.uidrivers.curses.GFsio import *

from gnue.common.apps import GDebug
from gnue.common.datasources import GLoginHandler
from gnue.common.utils.TextUtils import lineWrap

_NOTEBOOK = None
_EVENTPROCESSOR = None


#
# UILoginHandler
#
class UILoginHandler(GLoginHandler.LoginHandler):
##   def __init__(self):
##     self._wxapp = getWxApp()
##     self.dlg = None

   def getLogin(self, loginData, errorText=None):
     if 1: # TODO: This is left here to prevent me from having to unindent this code
           # TODO: Since the UI stuff is currently being gutted I'm not wasting the time
           # TODO: to do the right thing

       # Get the screen
       root = GetSIO()
       screen = ScreenContainer(root)

       if len(loginData[1]):
         loginMesg = 'Login required for "%s"' % (loginData[1])
       else:
         loginMesg = 'Login required for %s' % (loginData[0])

       gnueMesg = _("GNU Enteprise Forms")

       dlgWidth = max(len(loginMesg), len(gnueMesg)) + 4
       dlgHeight = 5

       labelList = []
       textctrlList = []
       labelMsgList = []

       fieldLabelWidth = 0

       for prompt in loginData[2]:
         labelMsgList.append('%s:' % prompt[1])
         fieldLabelWidth = max(fieldLabelWidth, len ('%s:' % prompt[1]))
         dlgWidth = max(dlgWidth, fieldLabelWidth + 23)
         dlgHeight += 1

       lbMesg = _('Login')
       cbMesg = _('Cancel')
       dlgWidth = max(dlgWidth, len(lbMesg) + len(cbMesg) + 11) + 2
       dlgHeight += 1

       #
       # Create widgets
       #

       w = dlgWidth + 2
       h = dlgHeight + 2
       x = int(root.MAXCOL/2 - w/2 + .5)
       y = int(root.MAXROW/2 - h/2 + .5)

       dlg = Dialog(screen, y, x,  y+h-1, x+w-1)

       gnueLabel = dlg.AddDialogControl(Label(dlg, "lbl1", 1,
                               int((dlgWidth - len(gnueMesg))/2),
                               gnueMesg))
       loginLabel = dlg.AddDialogControl(Label(dlg, "lbl1", 2,
                               int((dlgWidth - len(loginMesg))/2),
                               loginMesg))

       firstY = 4
       lastY = firstY
       xPos = int(dlgWidth/2 - fieldLabelWidth/2) - 11

       for prompt in loginData[2]:
         s = dlg.AddDialogControl(Label(dlg,"lbl2",lastY, xPos,'%s:' % prompt[1]))
         labelList.append(s)
         t = dlg.AddDialogControl(TextBox(dlg, "inp", lastY, xPos + fieldLabelWidth + 2, 20, Password=prompt[2]))
         textctrlList.append(t)
         lastY += 1

       loginButton = dlg.AddDialogControl(Button(dlg,"LoginButton",dlgHeight - 1,dlgWidth - len(cbMesg) - len(lbMesg) - 10,len(lbMesg)+4,lbMesg))
       loginButton.EXITFORM = 1
       cancelButton = dlg.AddDialogControl(Button(dlg,"CancelButton",dlgHeight - 1,dlgWidth - len(cbMesg) - 5,len(cbMesg)+4,cbMesg))
       cancelButton.EXITFORM = 1

       t = dlg.RunDialog()

       if dlg.Controls[t] == cancelButton:
         raise GLoginHandler.UserCanceledLogin

       rv = {}
       for i in range(0, len(loginData[2])):
         rv[loginData[2][i][0]] = textctrlList[i].TEXT

       return rv



