#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# UIdriver.py
#
# DESCRIPTION:
# A generic UIdriver base for common message-based GUI toolkits.
#
# NOTES:
#

import sys
import string

from gnue.common import events
from gnue.common.apps import GDebug
from gnue.common.apps import GConfig
from gnue.common.utils.TextUtils import lineWrap

from gnue.forms import VERSION
from gnue.forms.GFForm import *
from gnue.forms.uidrivers._base.UIdriver import *

#from common import *

#
# GFUserInterface
#
# The public interface to the User Interface
# All UIs must provide this class
#
class GFUserInterface(GFUserInterfaceBase):

  def __init__(self, *args, **parms):
    GFUserInterfaceBase.__init__(self,*args, **parms)

    # Shortcut
    self.images_dir = GConfig.getInstalledBase('forms_images','common_images') + '/'

    self._IdToTkObj = {}
    self._IdToGFObj = {}
    self._IdToUIObj = {}

    self._disabledColour = 0


  def _activateForm(self, form, modal=0):
    for key in self._formNameToUIForm.keys():
      if self._formNameToUIForm[key]._form == form:
        break

    if modal:
      self._formNameToUIForm[key].showModal()
    else:
      self._formNameToUIForm[key].show()


  #############################################################################
  #
  # Private UIBase support functions
  #
  # Called in UIbase functions to perform UI interaction with this specific
  # widget set.
  #

  # Can be used by UI drivers to add more attributes to the creation event.
  def _updateCreateEvent(self, event):
    event.eventHandler = self.dispatchEvent
    event.ui = self
    return event


  #############################################################################
  #
  # Incoming Event Processors
  #
  # Processes the incoming events from other objects
  # From here down should be nothing but eventListeners listed

  #
  # formAlert
  #
  # Rings a bell and alters the statusbar to display
  # a line of text
  #
  def formAlert(self, event):
    self._beep()
    self.statusBar.SetStatusText(event.data,0)

