#!/usr/bin/env python
#
# GNU Enterprise Forms - Installation Procedure
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py,v 1.92 2003/10/28 09:45:38 siesel Exp $

import sys
import os

from src import PACKAGE, VERSION

try:
  from gnue.common.setup import GSetup
except ImportError:
  print "You need GNUe-Common 0.5.2 or newer installed to install %s" % PACKAGE
  sys.exit (1)

# =============================================================================

class setup (GSetup.GSetup):

  package = PACKAGE.lower()

  # ---------------------------------------------------------------------------
  # Definition of basic parameters for distribution and installation.
  # Please add new files/directories that should be installed here.
  # Note that you also have to add them to MANIFEST.in.
  # ---------------------------------------------------------------------------

  def set_params (self, params):

    # The Work
    params ["name"]             = PACKAGE
    params ["version"]          = VERSION
    params ["description"]      = "GNU Enterprise Forms"
    params ["long_description"] = ""
    params ["license"]          = "GPL"

    # The Author
    params ["author"]       = "GNU Enterprise Team"
    params ["author_email"] = "gnue-dev@gnu.org"
    params ["url"]          = "http://www.gnue.org"

    # The Programs
    params ["package_dir"] = {"gnue.forms": "src"}
    params ["scripts"]     = ["scripts/gnue-forms"]

    # The Data
    dialogfiles = self.allfiles ("dialogs")
    imagefiles  = self.allfiles ("images")
    man1files   = self.allfiles ("doc/man")
    docfiles    = self.allfiles ("doc")
    samp01files = self.allfiles ("samples")
    samp02files = self.allfiles ("samples/dialog")
    samp03files = self.allfiles ("samples/history")
    samp04files = self.allfiles ("samples/intro")
    samp05files = self.allfiles ("samples/inventory")
    samp06files = self.allfiles ("samples/inventory/forms")
    samp07files = self.allfiles ("samples/inventory/sql")
    samp08files = self.allfiles ("samples/location")
    samp09files = self.allfiles ("samples/location/forms")
    samp10files = self.allfiles ("samples/location/sql")
    samp11files = self.allfiles ("samples/po")
    samp12files = self.allfiles ("samples/simple")
    samp13files = self.allfiles ("samples/track")
    samp14files = self.allfiles ("samples/track/forms")
    samp15files = self.allfiles ("samples/track/sql")
    samp16files = self.allfiles ("samples/vendor")
    samp17files = self.allfiles ("samples/vendor/forms")
    samp18files = self.allfiles ("samples/zipcode")
    samp19files = self.allfiles ("samples/connections")

    params ["data_files"] = \
      [("share/gnue/dialogs",                            dialogfiles),
       ("share/gnue/images/forms",                       imagefiles),
       ("share/man/man1",                                man1files),
       ("share/doc/gnue-forms",                          docfiles),
       ("share/doc/gnue-forms/examples",                 samp01files),
       ("share/doc/gnue-forms/examples/dialog",          samp02files),
       ("share/doc/gnue-forms/examples/history",         samp03files),
       ("share/doc/gnue-forms/examples/intro",           samp04files),
       ("share/doc/gnue-forms/examples/inventory",       samp05files),
       ("share/doc/gnue-forms/examples/inventory/forms", samp06files),
       ("share/doc/gnue-forms/examples/inventory/sql",   samp07files),
       ("share/doc/gnue-forms/examples/location",        samp08files),
       ("share/doc/gnue-forms/examples/location/forms",  samp09files),
       ("share/doc/gnue-forms/examples/location/sql",    samp10files),
       ("share/doc/gnue-forms/examples/po",              samp11files),
       ("share/doc/gnue-forms/examples/simple",          samp12files),
       ("share/doc/gnue-forms/examples/track",           samp13files),
       ("share/doc/gnue-forms/examples/track/forms",     samp14files),
       ("share/doc/gnue-forms/examples/track/sql",       samp15files),
       ("share/doc/gnue-forms/examples/vendor",          samp16files),
       ("share/doc/gnue-forms/examples/vendor/forms",    samp17files),
       ("share/doc/gnue-forms/examples/zipcode",         samp18files),
       ("share/doc/gnue-forms/examples/connections",     samp19files)]

  # ---------------------------------------------------------------------------
  # Build files to be distributed and installed:
  # Should generate the files that go in a distribution but aren't in SVN.
  # Gets called on sdist (always) and on build/install (only when run from SVN).
  # ---------------------------------------------------------------------------

  def build_files (self, action):
    # nothing to do here
    pass

  # ---------------------------------------------------------------------------
  # Check dependencies for installation:
  # Should sys.exit(1) in case any requirement isn't met.
  # Gets called on install.
  # ---------------------------------------------------------------------------

  def check_dependencies (self):

    # -------------------------------------------------------------------------
    # mxDateTime
    try:
      print "checking mxDateTime library"
      from mx.DateTime import DateTime
    except ImportError:
      print "---"
      print "Could not import the mx.DateTime package."
      print "Please install mxDateTime from the mxtools suite."
      print "The file 'INSTALL' contains more information about dependencies."
      sys.exit (1)

    # -------------------------------------------------------------------------
    # Verify at least one UI is installed
    UIOK = 0

    # PyNcurses
    print "checking Python ncurses library (pyncurses) (currently not working)"
    try:
      import ncurses.form
      UIOK = 0
    except ImportError:
      pass

    # Curses
    print "checking Python curses library (curses) (currently not working)"
    try:
      import curses
      UIOK = 0
    except ImportError:
      pass

    # wxPython
    print "checking wxPython library: ",
    if (os.environ.has_key('DISPLAY') and len(os.environ["DISPLAY"])) or \
       os.name!='posix':
      try:
        from wxPython import wx
        if wx.__version__[0:2]=='2.':
          print "ok (%s)" % wx.__version__
          UIOK = 1
          # WORKAROUND:
          # return now because subsequent import of pygtk will segfault.
          return
        else:
          print "Version 2.3 or greater needed"
      except ImportError:
        pass
    else:
      print "check not possible, X11 not working, assuming wxPython is there"
      UIOK = 1

    # pyGTK 2.0
    print "checking pyGTK 2.0 library: ",
    try:
      import pygtk
      pygtk.require('2.0')
      import gtk
      print 'ok.'
      UIOK = 1
    except ImportError:
      print 'not found.'
    except RuntimeError:
      print 'found (but X is not running).'
      UIOK = 1

    # win32ui
    print "checking win32all extensions: ",
    try:
      import win32ui
      print 'ok.'
      UIOK = 1
      return
    except ImportError:
      print 'not found.'

    # FIXME: We have more UIDrivers, add check for qt!

    if UIOK != 1:
      print "---"
      print """
No valid UI drivers are installed on this machine.
Please install one of the following packages:
  wxPython      - www.wxpython.org
  pyGTK2        - ftp://ftp.gtk.org/pub/gtk/python/v2.0/
  pyncurses     - pyncurses.sourceforge.net
  python curses - Read python install docs on how to activate
The file 'INSTALL' contains more information about dependencies.
"""
      sys.exit (1)

# =============================================================================

if __name__ == "__main__":
  setup().run()
