#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# Base.py
#
# DESCRIPTION:
"""
UI Driver for wxWidgets 2.4
"""
# NOTES:
#

import sys, os, string
from wxPython.wx import *
from gnue.forms.uidrivers.wx.GFwxApp import setWxApp

from startup.Startup import Startup
from Instance import Instance
from MenuBar import MenuBar

class UIBase(wxApp):


  ######################################################################
  ######################################################################
  ######################################################################
  ###
  ### Public methods
  ###
  ######################################################################
  ######################################################################
  ######################################################################

  def run(self):

    # Set form's wx app to be us
    setWxApp(self)

    # Reuse the login handler from Form's wx driver
    # This has to happen after setWxApp, otherwise bad things happen
    from gnue.forms.uidrivers.wx import UILoginHandler
    self.app.getConnectionManager().setLoginHandler(UILoginHandler())

    # Call wx's MainLoop
    self.app.init()
    self.MainLoop()

  def createInstance(self, instance):
    return Instance(instance)

  ######################################################################
  #
  # Startup Splash Screen
  #
  ######################################################################
  def createStartupSplash(self):
    self.__splash = Startup()

  def closeStartupSplash(self):
    self.__splash.pauseAndClose()

  ######################################################################
  #
  # Common dialogs
  #
  ######################################################################
  def dialogOk(self, text, title, parentWindow=None, icon="information", _cancel=False):
    """
    icon can be "question", "information", or "warn"
    @rtype: boolean
    @returns: True
    """
    if _cancel:
      buttonStyle = wxOK|wxCANCEL
    else:
      buttonStyle = wxOK

    if icon == 'question':
      iconStyle = wxICON_QUESTION
    elif icon == "warn":
      iconStyle = wxICON_EXCLAMATION
    elif icon == 'information':
      iconStyle = wxICON_INFORMATION
    else:
      # TODO: assert? error?
      iconStyle = wxICON_INFORMATION
    return wxMessageDialog(parentWindow or NULL, text, title,
                           buttonStyle|iconStyle ).ShowModal() == wxID_OK


  def dialogCancel(self, text, title, parentWindow=None, icon="warn"):
    """
    icon can be "question", "information", or "warn"
    @rtype: boolean
    @returns: True
    """
    return self.dialogOk(text, title. parentWindow, icon, _cancel=True)


  def dialogYesNo(self, text, title, parentWindow=None, icon="question"):
    """
    icon can be "question", "information", or "warn"
    @rtype: boolean
    @returns: True if user selected Yes, False otherwise.
    """
    if icon == 'question':
      iconStyle = wxICON_QUESTION
    elif icon == "warn":
      iconStyle = wxICON_EXCLAMATION
    elif icon == 'information':
      iconStyle = wxICON_INFORMATION
    else:
      # TODO: assert? error?
      iconStyle = wxICON_INFORMATION

    return wxMessageDialog(parentWindow or NULL, text, title,
             wxYES_NO|iconStyle ).ShowModal() == wxID_YES

  def dialogYesNoCancel(self, text, title, parentWindow=None, icon="question"):
    """
    icon can be "question", "information", or "warn"
    @rtype: int
    @returns: True (1) if user selected Yes, False (0) if No, -1 if canceled.
    """
    if icon == 'question':
      iconStyle = wxICON_QUESTION
    elif icon == "warn":
      iconStyle = wxICON_EXCLAMATION
    elif icon == 'information':
      iconStyle = wxICON_INFORMATION
    else:
      # TODO: assert? error?
      iconStyle = wxICON_INFORMATION

    rv = wxMessageDialog(parentWindow or NULL, text, title,
             wxYES_NO|wxCANCEL|iconStyle ).ShowModal()
    if rv == wxID_YES:
      return True
    elif rv == wxID_NO:
      return False
    else:
      return -1

  def dialogOpenFile(self, title, wildcards, parentWindow=None):
    """
    Prompts the user for a file to open.

    wildcards is a tuple of tuples, such as:
      (('*.*','All Files'), ('*.py','Python Scripts'))

    @rtype: string
    @returns: None if no file selected, or a full
              path name otherwise.
    """

    wcstring = ""
    for extension, description in wildcards:
      wcstring += "%s (*.%s)|*.%s|" % (description, extension, extension)

    dlg = wxFileDialog(parentWindow or NULL, title, defaultDir=os.getcwd(),
                           wildcard = wcstring,
                           style=wxOPEN)
    if dlg.ShowModal() != wxID_OK:
      ret = None
    else:
      ret = dlg.GetPath()

    dlg.Destroy()
    return ret

  def dialogSaveFile(self,title, wildcards, parentWindow=None):
    """
    Prompts the user for a file name to save as.

    @rtype: string
    @returns: None if no file selected, or a full
              path name otherwise.
    """
    wcstring = ""
    for extension, description in wildcards:
      wcstring += "%s (*.%s)|*.%s|" % (description, extension, extension)
    wcstring = wcstring[:-1]

    dlg = wxFileDialog(parentWindow or NULL, title,
                           defaultDir=os.getcwd(),
                           wildcard = wcstring,
                           style=wxSAVE)
    if dlg.ShowModal() != wxID_OK:
      return None
    else:
      return dlg.GetPath()


  ##########################################################
  ##########################################################
  ##########################################################
  ###
  ### Internal Methods
  ###
  ##########################################################
  ##########################################################
  ##########################################################

  ##########################################################
  #
  # wxApp methods
  #
  ##########################################################
  def OnInit(self):
    """
    Standard wxApp OnInit function.
    Designer uses it to display the startup screen and
    load the initial editor instance

    @rtype: boolean
    @return: Always true
    """
    return True

  ##########################################################
  #
  # Misc internal methods
  #
  ##########################################################

  def __init__(self, app):
    print "__init__"
    self.app = app
    wxApp.__init__(self, False) # prevents IO redirect
    wxInitAllImageHandlers()


