#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# schema/TreeView.py
#
# DESCRIPTION:
#
# NOTES:
#
# TODO: all the SetItemImage lines in this file have been commented out as on win32 it was segfaulting

import sys, os
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.designer.base.Icons import treeIconMap, treeIconList
from gnue.designer.base.tools.TreeView import TreeView as BaseTreeView

class TreeView (BaseTreeView):

  rootDescr = 'Schema'

  def inventoryObject (self, object):
    if object != self.rootObject:
      icon = 'properties'
      try:
        parentTreeItem = object.getParent ()._treeItem
      except AttributeError:
        parentTreeItem = None
        # TODO:
        print "The parent object of this object has not been registered to "+\
              "the TreeView inventory. It is not possible to add this "+\
              "object to the inventory at the moment. This needs to be "+\
              "fixed. (Obj: ",object,")."

        return
      if object._type == 'GSTables':
        icon = 'datasource'
      elif object._type == 'GSTable':
        icon = 'block'
      elif object._type == 'GSField':
        icon = 'entry'

      object._treeItem = self.AppendItem(parentTreeItem,
          "%s" % object.getDescription())
      self.tree.SetPyData(object._treeItem, object)
      #self.tree.SetItemImage(object._treeItem, treeIconMap[icon])


