#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# schema/Instance.py
#
# DESCRIPTION:
# Creates a "schema" instance
#
# NOTES:
#

from gnue.designer.schema import properties as schemaProperties
from gnue.designer.base.Instance import BaseInstance
from gnue.common.datasources import GSchema
from Incubator import Incubator
import wizards

# Tool support...
from LayoutEditor import LayoutEditor
from TreeView import TreeView
from TableEditor import TableEditor
from gnue.designer.base.tools.PropertyEditor import PropertyEditor
from gnue.designer.base.tools.DataSourceEditor import DataSourceEditor
##from gnue.designer.base.tools.SchemaViewer import SchemaViewer
from gnue.designer.base.tools.SchemaNavigator import SchemaNavigator
from gnue.designer.schema.DiaEditor.VisualEditor import VisualEditor



class Instance(BaseInstance):

  def __init__(self, app, *args, **params):
    self.incubator = Incubator(self)
    self.properties = schemaProperties

    self._tableMappings = {}
    BaseInstance.__init__(self, app, *args, **params)


  def loadBuffer(self, buffer):
    schema = GSchema.loadFile (buffer, self, initialize=0)
    schema.name = 'schema'
    return schema


  def loadEmpty(self, style=None):
    schema = GSchema.GSSchema()
    schema.title = "Untitled schema"
    schema.name = 'schema'
    GSchema.GSTables(schema)
    return schema


  def inventoryObject(self, object):
    if isinstance(object, GSchema.GSTables):
      self.tables = object
    elif object._type == 'GSTable':
      self._tableMappings[object.name] = object
      object._fieldList = []
      object._fieldMap = {}
    elif object._type == 'GSField':
      table = object.findParentOfType('GSTable')
      table._fieldList.append(object)
      table._fieldMap[object.name.lower()] = object

  def createTools(self):
    self.addTool('tableEditor',   _('Table/Field Editor'), TableEditor,
                      hotkey='F11', menuGroup=301)
    self.addTool('propertyEditor', _('Property Inspector'), PropertyEditor,
                      hotkey='F10', menuGroup=301)
    self.addTool('treeEditor',     _('Object Navigator'), TreeView,
                      hotkey='F8', menuGroup=311)

    self.addTool('schemaNavigator',_('Schema Navigator'), SchemaNavigator,
                      menuGroup=301)
    self.addTool('visualEditor',_('Visual Editor'), VisualEditor,
                      hotkey='F9', menuGroup=311)

  def createWizards(self):
    self.loadWizards(wizards)

  def preSave(self):
    pass

  # Used by TemplateParser to build a wizard.current dict
  def buildWizardCurrentDict(self):
    return {'schema': self.rootObject,
            'tables': self.tables,
            'table': self.tableEditor.table,
##            'field': self.visualEditor.page,
            'object': self._currentObject}


##  # Hack having to do with UIwxpython import
##  def uiEventTrap(self, event):
##    pass




