#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/wizards/AddDataSource.py
#
# DESCRIPTION:
# Add a DataSource entry to a form, creating any datasources if necessary.
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string

#
# Steps
#
# 0. Get id/field/[Existing Datasource/New Datasource /Static Set]
# 1. Select / create datasource
#

class AddDataSourceWizard(FormTemplate):


  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Initialize any runtime variables
  #
  def Start(self, root, current):
    self.form = root
    self.current = current
    self.__getExistingDatasources()


  ###############
  #
  # Return the markup for a specific page
  #
  def GetStep(self, stepCode):

    #
    # Step #1 / Get Title, et al
    #
    if stepCode == '0':

      if self.__firstConnection:
        self.variables['connection'] = self.__firstConnection

      return   { 'title': 'Add DataSource',
                 'content': (WizardText('To create your DataSource, I need to know some basic information.\n\n'
                                        'What connection should this form use to connect to the \ndatabase?'),
                             WizardInput('connection',label='Connection:', required=1,
                                         set=self.GetAvailableConnections()),
                             WizardText('You may be asked to login to this connection.')),
                 'prev': None,
                 'next': '1' }

    #
    # Step #2 [New Datasource] / Get Table
    #
    elif stepCode == '1':
      return   { 'title': 'Select Validator Table/Source',
                 'content': (WizardText('Now, please select the table the DataSource will\nuse to populate its data set.'),
                             WizardInput('table', label='Table:', required=1, lines=5,
                                         set=self.GetAvailableSources(self.variables['connection'])), ),
                 'prev': '0',
                 'next': '2' }


    #
    # Step #3 [New Datasouce] / Get key/description fields
    #
    elif stepCode == '2':

      if not hasattr (self.variables,'name'):
        self.variables['name'] = 'dts_%s' % self.variables['table']

      return   { 'title': 'Select Key/Description fields',
                 'content': (WizardText('What shall I call this datasource?'),
                             WizardInput('name', label='Name:', required=1)),
                 'prev': '1',
                 'next': None }


  ###############
  #
  # Verify contents of current step
  # Return None if no problems, otherwise
  # return a tuple of error message strings
  #
  def ValidateStep(self, stepCode):

    # TODO: This should validate step 1:fixed to verify the dataset is valid
    return None



  ###############
  #
  # We have all the data, so generate our form. This
  # is called after the user clicks the "Finish" button.
  # No more user input is allowed at this point.
  #
  def Finalize(self):

    #
    # Set up or retrieve our datasource
    #

    # Create new datasource
    datasource = self.AddElement('datasource', self.form,
        { 'name': self.GetUniqueName(self.variables['name']),
          'connection': self.variables['connection'],
          'table': self.variables['table'] } )


    return 1


  ###############
  #
  # Internal stuff
  # Get a list of all existing datasources
  #
  def __getExistingDatasources(self):
    self.__firstConnection = None
    for child in self.form.findChildrenOfType('GFDataSource'):
      if hasattr(child,'table'):
        if not self.__firstConnection:
          self.__firstConnection = child.connection
          break





############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    'BaseID' : 'AddDataSource',
    'BaseClass' : AddDataSourceWizard,
    'Name' : _('Add a new Data Source'),
    'Description' : _('Inserts a new DataSource'),
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,
    'MenuLocation' : ('Insert',_('Datasource'), 301.2)
}

