# -*- coding: iso-8859-1 -*-
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/wizards/CreateWebForm.py
#
# DESCRIPTION:
# a wizard which export the actual form into a dynamic HTML file
# with javascript includes, which can act as a webform.
#
# VERSION:   0.0.2 (needs gnue-forms.js ver. 0.0.2)
#
# NOTES/TODO:
#     a) Wizard Dialog
#         -  add step to choose 'included image orgin' (subdir: "img/",
#            topdir: "/img/", "other host...
#         -  option to deactivate/activate Statusbar, Buttonbar, a Menu
#         -  option to switch between different layout styles
#
#     b) Code Creation
#         - use em/en sizes for absolute positioning (drawback:depend on font size)
#         - menu bar creation
#         - add GFBox, GFImage types
#         - add more GFEntry styles (f.e. dropdown)
#         - add tooltips to Toolbar Icons
#         - support multiple rows
#         - create page switching tab (if enabled)
#         - add code for a login/logged out window on top of the form (done)


from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string


class CreateWebFormWizard(FormTemplate):


  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Define some settings, which could be configured
  #

  # the default name of the webserver
  DEFAULT_SERVERNAME=""


  ###############
  #
  # Initialize any runtime variables
  #
  def Start(self, root, current):
    self.form = root
    self.current = current
    self.Xsize=0
    self.Ysize=0
    self.Xraster=15
    self.Yraster=30
    self.yBase=10
    self.xBase=5
    self.baseline=6
    self.fontsize=18
    self.lineheight=35
    self.fontsize_entry=12
    self.statusBar=1
    self.buttonBar=1


  ###############
  #
  # Return the markup for a specific page
  #
  def GetStep(self, step):

    # 0 - Get filename
    # 1 - Confirm

    #
    # Step #0 / Get Filename Name
    #
    if step == '0':

      self.variables['cellwidth']=str(self.Xraster)
      self.variables['cellheight']=str(self.Yraster)

      content = [WizardText('This will build a dynamic web form writen in '+
                            'HTML and Javascript. For more information '+
                            'confer to "jsclient/INSTALL.TXT".\n\n '),
                 WizardInput('file',label='File Name:',required=1,size=20),
                 WizardText('\n\nChoose default cell size (in Pixel):'),
                 WizardInput('cellwidth',label='Cell Width  :',
                             required=1,size=10),
                 WizardInput('cellheight',label='Cell Height :',
                             required=1,size=10)]

      return   { 'title': 'Create Web Forms File',
                 'content': content,
                 'prev': None,
                 'next': '1' }

    if step == '1':

      self.computePageSize(self.form.findChildOfType("GFLayout"))

      if self.variables['file'][-5:]!=".html":
        self.variables['file']+=".html"

      self.Xraster=int(self.variables['cellwidth'])
      self.Yraster=int(self.variables['cellheight'])
      self.baseline=int(self.Yraster*6/35)
      self.fontsize=int(self.Yraster*18/35)
      self.lineheight=self.Yraster
      self.fontsize_entry=int(self.Yraster*16/35)

      self.variables['encoding']=gConfig('textEncoding')
      choices=(('iso8859-1','Western'),
               ('utf-8','Unicode'),
               ('big5','Trad. Chinese' ),
               ('gb2312','Simpl. Chinese' ),
               ('jis','Japanese' ))

      content = [WizardText('The web form will be stored in the file '+
                            ('%s.\n\n' % self.variables['file'])),
                 WizardText('Form Size: %sx%s => ' % \
                            (self.Xsize,self.Ysize)+\
                            '%sx%s Pixel' % \
                            (self.Xsize*self.Xraster,
                             self.Ysize*self.Yraster)),
	         WizardInput('encoding',label='Default Encoding :',
                             required=1,size=10,set=choices)]

      return   { 'title': 'Create Web Forms File',
                 'content': content,
                 'prev': '0',
                 'next': None }


  ###############
  #
  # Verify contents of current step
  # Return None if no problems, otherwise
  # return a tuple of error message strings
  #
  def ValidateStep(self, stepCode):

    # The Simple wizard uses basic "required"
    # settings in the page markup, so doesn't
    # need any special validation.
    return None



  ###############
  #
  # We have all the data, so generate our form. This
  # is called after the user clicks the "Finish" button.
  # No more user input is allowed at this point.
  #
  def Finalize(self):

    title = "GNUe jsForms: Untitled Form"

    if hasattr(self.form,"title"):
      title = "GNUe jsForms: %s" % self.form.title

    dest = open(self.variables['file'],"w")

    dest.write("<HTML>\n  <HEAD>\n   <TITLE>%s</TITLE></HEAD>" % title)

    charset=self.variables['encoding']

    dest.write('<meta http-equiv="Content-Type" content="text/html;'+\
               ' charset=%s">\n  </HEAD>\n' % charset)

    dest.write('<BODY onLoad="setup();form.run();" onUnload="form.close();">')

    if hasattr(self,'showtitle'):
      dest.write('<H1>%s</H1>' % title)

    # write javascript include
    dest.write('<SCRIPT src="vcXMLRPC.js"></SCRIPT>\n' +\
               '<SCRIPT src="gnue-forms.js"></SCRIPT>\n')
    # write datasource data, trigger information etc.
    dest.write(self.buildCode(self.form))

    if self.buttonBar:
      dest.write(self.addButtonBar())


    # Create Formpages
    visible=1
    layout=self.form.findChildOfType("GFLayout")

    if hasattr(layout,"tabbed") and len(layout.tabbed)>0:
      # Create Page tabs
      pos=0
      for child in layout._children:
        if child._type=="GFPage":
          dest.write(self.addPageTab(child.name,pos))
          pos+=200
          # TODO: support top,down,left,right instead of converting everything to top
      self.yBase+=self.Yraster


    dest.write(self.addBackground())


    for child in layout._children:
      if child._type=="GFPage":
        ## dest.write("<h2>%s</H2>" % child.name)
        dest.write('<DIV id="%s_page">' % child.name)
        dest.write(self.drawElements(child,visible))
        dest.write("</DIV>")
        visible=0


    if self.statusBar:
      dest.write(self.addStatusBar())

    dest.write(self.addLoginDialog())
    dest.write("<BODY></HTML>")
    dest.close()

    return 1

  def buildCode(self,obj):
    # TODO: reuse GFParser for this stuff
    outp=""

    if obj._type=="GFForm":
      outp+='<script language="JavaScript"><!--\n' +\
             'var form;\n' +\
             '// add aditional function, because only functions '+\
             'have real global scope.\n' +\
             'function getForm() {\n' +\
             '  return form;\n' +\
             '};\n' +\
             'function setup() {\n' +\
             'form = new GFForm(form);\n' +\
             "form.title='%s';\n\n" % obj.title

    if obj._type=='GFDataSource':
      outp+="dts = new GFDataSource(form);\n"
      outp+="dts._setParent(form);\n"
      outp+="dts.name='%s';\n" % obj.name
      outp+="dts.table='%s';\n" % obj.table

      if hasattr(obj,"order_by"):
        outp+="dts.order_by='%s';\n" % obj.order_by

      if hasattr(obj,"prequery"):
        outp+="dts.prequery='%s';\n" % obj.prequery

      if hasattr(obj,"detaillink"):
        outp+="dts.detaillink='%s';\n" % obj.detaillink

      if hasattr(obj,"master"):
        outp+="dts.master='%s';\n" % obj.master

      if hasattr(obj,"masterlink"):
        outp+="dts.masterlink='%s';\n" % obj.masterlink

      if hasattr(obj,"cache"):
        outp+="dts.cache=%s;\n" % obj.cache

      outp+="dts.connection='%s';\n\n" % obj.connection


    if obj._type=="GFLogic":
      pass

    if obj._type=='GFBlock':
      outp+="blk = new GFBlock(form);\n"
      outp+="blk._setParent(form);\n"
      outp+="blk.name='%s';\n" % obj.name
      outp+="blk.datasource='%s';\n\n" % obj.datasource

    if obj._type=='GFField':
      outp+="field = new GFField(blk);\n"
      outp+="field._setParent(blk);\n"
      outp+="field.name='%s';\n" % obj.name
      if hasattr(obj,"field"):
        outp+="field.field='%s';\n" % obj.field
      else:
        outp+="field.field='%s';\n" % obj.name

      if hasattr(obj,'default'):
        # TODO: fix default values (default is a keyword in javascript)
        outp+="field._default='%s';\n" % obj.default

      if hasattr(obj,'max_length'):
        outp+="field.max_length='%s';\n" % obj.max_length
      # TODO: add rest of attributs
      outp+="\n"

    if obj._type=='GFPage':
      outp+="page = new GFPage(form);\n" # do we need to add gflayout?
      outp+="page._setParent(form);\n"
      outp+="page.name='%s';\n" % obj.name

    if obj._type=='GFLabel':
      outp+="label = new GFLabel(page);\n" # do we need to add gflayout?
      outp+="label._setParent(page);\n"
      outp+="label.name='%s';\n\n" % obj.name

    if obj._type=='GFBox':
      outp+="box = new GFBox(page);\n"    # do we need to add gflayout?
      outp+="box._setParent(page);\n"
      outp+="box.name='%s';\n\n" % obj.name

    if obj._type=='GFButton':
      outp+="btn = new GFButton(page);\n" # do we need to add gflayout?
      outp+="btn._setParent(page);\n"
      outp+="btn.name='%s';\n\n" % obj.name
      # TODO: add simple trigger script

    if obj._type=='GFEntry':
      outp+="entry = new GFEntry(page);\n"
      outp+="entry._setParent(page);\n"
      outp+="entry.name='%s';\n" % obj.name
      outp+="entry.block='%s';\n" % obj.block
      if hasattr(obj,"field"):
        outp+="entry.field='%s';\n" % obj.field
      #else:
      #  outp+="entry.field='%s';\n" % obj.name

      if hasattr(obj,'__Char_x'):
        outp+="entry.__char_x='%s';\n" % obj.__Char_x

      if hasattr(obj,'__Char_y'):
        outp+="entry.__char_y='%s';\n" % obj.__Char_y

      if hasattr(obj,'__Char_width'):
        outp+="entry.__char_width='%s';\n" % obj.__Char_width

      if hasattr(obj,'__Char_height'):
        outp+="entry.__char_height='%s';\n" % obj.__Char_heigth

      ## Foreign key (f. dropdown) support
      if hasattr(obj,'fk_source'):
        outp+="entry.fk_source='%s';\n" % obj.fk_source

      if hasattr(obj,'fk_key'):
        outp+="entry.fk_key='%s';\n" % obj.fk_key

      if hasattr(obj,'fk_description'):
        outp+="entry.fk_descripion=%s';\n" % obj.fk_description
      outp+='\n'



    if obj._type=='GFOption':
      pass

    for child in obj._children:
      outp+=self.buildCode(child)

    if obj._type=="GFForm":
      outp+='}\n</script>\n'

    return outp

  def addBackground(self):
    outp='<DIV STYLE="position:absolute; '+\
           'top: %spx;' % self.yBase +\
           'left: %spx;\n' % self.xBase +\
           'width: %spx;' % (self.Xsize*self.Xraster) +\
           'height: %spx;\n' % (self.Ysize*self.Yraster) +\
           'border-width: 1px;'+\
           'border-style: solid;\nbackground-color:#EEEEEE;" align="center">\n'
    outp+='&nbsp;'
    outp+='</DIV>'
    return outp

  def addPageTab(self,name,pos):
    # outp = '<center><br><img src="img/gnue.png"><br></center>'
    outp='<DIV STYLE="position:absolute; '+\
           'top: %spx;' % self.yBase +\
           'left: %spx;\n' % (self.xBase+pos) +\
           'width: %spx;' % 180 +\
           'height: %spx;' % self.Yraster +\
           'border-width: 1px;'+\
           'border-style: solid;background-color:#EEEEEE;"\n' +\
           'align="center" onclick="getForm().gotoPage(' +\
           "'%s');" % name + '">\n'
    outp+='%s' % name
    outp+='</DIV>'
    return outp

  def showButton(self,img,name,alt,command,key):
    b='<img src="images/'+img+'-24x24.png" name="'+name+'" alt="'+alt+\
       '" onclick="'+ command+';">\n';
    return b

  def addButtonBar(self):
    # outp = '<center><br><img src="img/gnue.png"><br></center>'
    outp='<DIV STYLE="position:absolute; '+\
           'top: %spx;' % self.yBase +\
           'left: %spx;\n' % (max([self.Xsize*self.Xraster,540])/2+self.xBase-270) +\
           'width: %spx;' % 540 +\
           'border-width: 1px;'+\
           'border-style: solid;\nbackground-color:#EEEEEE;" align="center">\n'

    self.yBase=self.yBase+50

    outp+=self.showButton('commit',"commit","Commit","getForm().commit();",'n')
    outp+=self.showButton('newrecord',"newrec","New Record","getForm().newrec();",'n')
    outp+=self.showButton('markfordelete',"trash","Mark for Removal",
                          "getForm().del();",'n')
    outp+='&nbsp;&nbsp;'
    outp+=self.showButton('prevrecord',"prev","Previous Record","getForm().prev();",'')
    outp+=self.showButton('nextrecord',"next","Next Record","getForm().next();",'')
    outp+='&nbsp;&nbsp;'
    outp+=self.showButton('enterquery',"prepq","Prepare Query","getForm().prepQ();",'')
    outp+=self.showButton('execquery',"query","Execute Query","getForm().execQ();",'')
    outp+='&nbsp;&nbsp;'
    outp+=self.showButton('rollback',"rollback","Rollback","getForm().rollback();",'')
    outp+='&nbsp;&nbsp;'
    outp+=self.showButton('about',"help","About","getForm().about();",'')
    outp+='&nbsp;&nbsp;'
    outp+=self.showButton('exit',"close","","getForm().close();",'')
    outp+='</DIV>'
    return outp;

  def addStatusBar(self):
    return '''
<DIV STYLE="position:absolute; top: %spx;left: %spx;width: %spx;border-width: 1px; border-style: solid;background-color:#EEEEEE;" align="right">
     <div id="status" style="display:inline"></div>|
     <div id="pos" style="display:inline"></div>|
     <div id="max" style="display:inline"></div>&nbsp;&nbsp;
</DIV>
''' % (((self.Ysize+2)*self.Yraster)+self.yBase+20,\
       (max([self.Xsize*self.Xraster,540])/2+self.xBase-270),540)


  def computePageSize(self,obj):
    if ((obj._type=='GFEntry') or  (obj._type=='GFLabel') or \
        (obj._type=='GFButton')) and not obj.hidden:

      if not hasattr(obj,'Char__width'):
        if (obj._type=='GFLabel'):
          obj.Char__width=len(obj.text)
        else:
          obj.Char__width=10 # TODO: use default from gConfig instead

      if not hasattr(obj,'Char__height'):
        obj.Char__height=1 # TODO: use default from gConfig instead

      # compute max/min
      if obj.Char__x+obj.Char__width>self.Xsize:
        self.Xsize=int(obj.Char__x+obj.Char__width+1)

      if obj.Char__y+obj.Char__height>self.Ysize:
        self.Ysize=int(obj.Char__y+obj.Char__height+1)

    for child in obj._children:
      self.computePageSize(child)


  # function build the html code for page
  def drawElements(self,obj,visible):

    outp=""

    if ((obj._type=='GFEntry') or (obj._type=='GFLabel') or \
        (obj._type=='GFButton') or (obj._type=='GFBox')) and not obj.hidden:

      pos_code='STYLE="position:absolute; '+\
                'top: %spx;' % int(obj.Char__y*self.Yraster+self.yBase) +\
                'left: %spx;' % int(obj.Char__x*self.Xraster+self.xBase) +\
                'width: %spx;' % int(obj.Char__width*self.Xraster) +\
                'height: %spx;\n  ' % int(obj.Char__height*self.Yraster-self.baseline)

      if visible==0:
	pos_code+='visibility:hidden;'

      if obj._type=='GFLabel':
        pos_code+='font-size: %spx;' % int(self.fontsize) +\
                   'line-height: %spx' % int(self.lineheight)
      else:
        pos_code+='font-size: %spx;' % int(self.fontsize_entry)

      if obj._type=='GFEntry':
        pos_code+='background: #F6F6F6;'

      if obj._type=='GFBox':
        pos_code+='border-width: 1px; border-style: solid;"'
      else:
        pos_code+='"'

      # TODO: add loop for row setting
      if obj._type=='GFEntry':
        # TODO: add dropdown, height
        outp+='\n\n  <!-- Entry %s -->\n' % obj.name
        if obj.style=="password":
          outp+='  <input type="password"'
        elif obj.style=="dropdown":
          outp+='  <select'
	  print "ATTENTION: creating dropdown widgets which are not supported by the javascript client yet!"
        elif obj.Char__height>1:
          outp+='  <textarea'
        else:
          outp+='  <input type="text"'

        outp+=' name="%s"\n  id="%s_%s_field" ' % (obj.name,obj.block,obj.field)

        outp+='\n  onfocus="getForm().gotoBlock('+"'%s'" % obj.block +\
               ');"\n';

        outp+=pos_code;

        if not hasattr(obj,"default"):
          obj.default=""

        if obj.style=="dropdown":
          outp+='><options>%s</options></select>\n' % obj.default
        elif obj.Char__height>1:
          outp+='>%s</textarea>\n' % obj.default
        else:
          outp+='value="%s">\n' % obj.default


      elif obj._type=='GFLabel':
        outp+='\n  <!-- Label %s -->\n' % obj.name
        outp+='  <DIV %s id="%s_label">%s</DIV>\n' %\
               (pos_code,obj.name,obj.text)

      elif obj._type=='GFButton':
        outp+='\n  <!-- Button %s -->\n' % obj.name
        outp+='  <button %s id="%s_button">%s</button>\n' % \
               (pos_code,obj.name,obj.label)

      elif obj._type=='GFBox':
        outp+='\n  <!-- Box %s -->\n' % obj.name
        outp+='  <div %s id="%s_box">%s</div>\n' % \
               (pos_code,obj.name,obj.label)



    for child in obj._children:
      outp+=self.drawElements(child,visible)

    return outp

  def addLoginDialog(self):
    outp='<DIV STYLE="position:absolute; '+\
         'top: %spx;' % int(max([self.Ysize*self.Yraster,200])/2+self.yBase-100) +\
         'left: %spx;' % int(max([self.Xsize*self.Xraster,500])/2+self.xBase-175)+\
         'width: %spx;\n' % int(350) +\
         'height: %spx;' % int(200) +\
         'border-width: 1px; border-style: solid;'+\
         'background-color:#EEEEEE;visibility=visible"\n '+\
         'id="loginForm" align="center">\n'
    outp+='&nbsp;<BR>User:&nbsp;&nbsp;&nbsp;&nbsp; '+\
           '<INPUT type="text" id="username"><BR>\n'
    outp+='Password: <INPUT type="password" id="password"><BR><BR>\n'
    outp+='<BUTTON onClick="getForm().doLogin();">Login</BUTTON>\n</DIV>\n'
    return outp;




############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    'BaseID' : 'CreateWebForm',
    'BaseClass' : CreateWebFormWizard,
    'Name' : _('Compile Form for GNUe JsForms'),
    'Description' : _('Create an intermediate html+java for the jsForms client'),
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,
    'MenuLocation' : (_('Tools|Extras'),_('Compile Form for GNUe JsForms'))
}

if __name__ == "__main__":
  pass
  # TODO: add some code to use this wizard standalone
