#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# WidgetHandler.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from Utils import *
from gnue.common.apps import GDebug
import cPickle

# LayoutEditor support files
from WidgetHighlighter import WidgetHighlighter
from PopupEditor import PopupEditor

#
#
#
class WidgetHandler(wxEvtHandler):
  def __init__(self, instance, object):
    wxEvtHandler.__init__(self)
    self.editor = instance
    self.object = object
    self.hasFocus = 0
    self.highlightBox = WidgetHighlighter(self.editor.panel)
    self._iMoved = 0
    self._alreadySelected = 0
    self._popup_editor = None

  def initialize(self, widget):
    self.widget = widget.widgets[0]
    self.mainWidget = widget
    self.selected = 0

    self.recalcBoundaries()

    for widget in self.mainWidget.widgets:
      widget.SetCursor (wxSTANDARD_CURSOR)

#      try:
#        widget.Enable(0)
#      except:
#        pass

      try:
        widget.SetEditable(0)
      except:
        pass

      self.setAllChildren(EVT_KEY_UP, widget, self.editor.keyTrap)
      self.setAllChildren(EVT_SET_FOCUS, widget, self.focusGainedTrap)
      self.setAllChildren(EVT_KILL_FOCUS, widget, self.focusLostTrap)
      self.setAllChildren(EVT_LEFT_UP, widget, self.OnLeftUp)
      self.setAllChildren(EVT_LEFT_DOWN, widget, self.OnLeftDown)
      self.setAllChildren(EVT_RIGHT_DOWN, widget, self.OnRightDown)
      self.setAllChildren(EVT_RIGHT_UP, widget, self.OnRightUp)
      self.setAllChildren(EVT_MOTION, widget, self.OnMotion)
      self.setAllChildren(EVT_LEFT_DCLICK, widget, self.onLeftDClick)
    self.setAllChildren(EVT_KEY_UP, self.highlightBox, self.editor.keyTrap)
    self.setAllChildren(EVT_SET_FOCUS, self.highlightBox, self.focusGainedTrap)
    self.setAllChildren(EVT_KILL_FOCUS, self.highlightBox, self.focusLostTrap)
    self.setAllChildren(EVT_LEFT_UP, self.highlightBox, self.OnLeftUp)
    self.setAllChildren(EVT_LEFT_DOWN, self.highlightBox, self.OnLeftDown)
    self.setAllChildren(EVT_RIGHT_UP, self.highlightBox, self.OnRightUp)
    self.setAllChildren(EVT_MOTION, self.highlightBox, self.OnMotion)

    self.widget.Refresh()

  def recalcBoundaries(self):
    x1,y1,x2,y2 = (9999999,9999999,0,0)

    for widget in self.mainWidget.widgets:
      tx, ty = widget.GetPositionTuple()
      tw, th = widget.GetSizeTuple()
      self.editor.positionMappings[widget] = [tx,ty,tx+tw-1,ty+tw-1,self]
      if tx < x1:
        x1 = tx
      if ty < y1:
        y1 = ty
      if tw + tx > x2:
        x2 = tw + tx
      if th + ty > y2:
        y2 = th + ty

    self.highlightBox.setBoundary(x1-2,y1-2,x2+2,y2+2)
    for widget in self.mainWidget.widgets:
       widget.Refresh()


  def setSelected(self, selected, focused=1):
    self.selected = selected
    self.focused = focused
    self.highlightBox.setSelected(selected, focused)


  def setAllChildren(self, event, widget, trap):
    try:
      event(widget, trap)
    except:
      pass
    for child in widget.GetChildren():
      self.setAllChildren(event, child, trap)

  def focusGainedTrap(self, event):
    self.editor.panel.SetFocus()
    pass
#    event.Skip()

  def focusLostTrap(self, event):
    event.Skip()


  def beginDragDrop(self, event):

    # Drag and drop TODO: This needs changed to pull all selected widgets

    object = self.object

    x,y = event.GetPositionTuple()

    data = [ { "Type" : "selectedWidgets",
               "Attributes": {
                   'startingX': object.Char__x + int(x/self.editor.gridWidth),
                   'startingY': object.Char__y + int(y/self.editor.gridHeight),
                   }
               }]
#        "name": dname,
#        "table": object.name,
#        "database": self.connectionName } }
#
#
    do = wxCustomDataObject(wxCustomDataFormat("application/x-gnue-designer"))
    do.SetData(cPickle.dumps(data,1))

##    icon = FeedbackBitmap(10,10).icon()
    dropSource = MoveDropSource(self, self.editor)
    dropSource.SetData(do)
    result = dropSource.DoDragDrop(true)
    event.Skip()


  def OnLeftDown(self, event):

    if self.editor.mode == 'move':

      self.mouseStartX, self.mouseStartY = event.GetPositionTuple()
      self._iMoved = 0

      if event.ShiftDown():
        selections = self.editor._currentSelection[:]
      else:
        selections = []

      if self.object in selections:
        if event.ShiftDown():
          del selections[selections.index(self.object)]
      else:
        selections.append(self.object)

      self.editor._instance.dispatchEvent('ObjectSelected',object=self.object,
                                             originator="Forms::LayoutEditor",
                                             selection=selections)
    else:
      xo, yo = self.widget.GetPosition()
      x, y = event.GetPositionTuple()
      self.editor.handleLeftDown(x+xo,y+yo)

    event.Skip()


  def OnLeftUp(self, event):
    if self.editor.mode == 'move':
      if self._iMoved:
        self._iMoved = 0
    else:
      xo, yo = self.widget.GetPosition()
      x, y = event.GetPositionTuple()
      self.editor.handleLeftUp(x+xo,y+yo)

    event.Skip()


  def OnMotion(self, event):

    if not self._iMoved and event.LeftIsDown():
      self._iMoved = 1
      self.beginDragDrop(event)

    event.Skip()


  def OnRightDown(self, event):
    event.Skip()


  def OnRightUp(self, event):
    if self.editor.mode == 'move':
      pt = event.GetPositionTuple()
      self.editor.dispatchEvent('ObjectSelected',object=self.object, originator=None)
      wxPyTypeCast(event.GetEventObject(),'wxWindow') \
         .PopupMenu(self.object._popupMenu, pt)
    event.Skip()


  def _endPopupEditor(self, success, value=""):
    if success:

      try:
        oldVals = {self.__popupAttr:self.object.__dict__[self.__popupAttr]}
      except KeyError:
        oldVals = {self.__popupAttr:None}
      newVals = {self.__popupAttr: value}
      self.object.__dict__.update(newVals)
      self.editor.dispatchEvent('ObjectModified', object=self.object,
                                  originator="Forms::LayoutEditor",
                                  old=oldVals,
                                  new=newVals)

      self._popup_editor.Destroy()
      self._popup_editor = None
      self.widget.SetLabel(value or "<Unset>")
      if self.object._type == 'GFLabel':
        width = len(value) or 10
        self.widget.SetSize((width * self.editor.gridWidth,
                            self.widget.GetSize().height))
        self.recalcBoundaries()
        self.setSelected(self.selected)


  def onLeftDClick(self, event):

    if self.editor.mode == 'move':
      if self.object._type in ('GFBox','GFLabel'):
        # Create a popup text editor for the labels
        if self.object._type == 'GFBox':
          self.__popupAttr = 'label'
          x = self.widget.GetPosition().x + (self.editor.gridWidth/2)
          width = (self.object.Char__width - 2) * self.editor.gridWidth
        else:
          self.__popupAttr = 'text'
          x = self.widget.GetPosition().x
          width = self.widget.GetSize().width + self.editor.gridWidth

        self._popup_editor = PopupEditor(self.editor.workspace,
            self._endPopupEditor,
            x + self.editor.panel.GetPosition().x,
            self.widget.GetPosition().y + self.editor.panel.GetPosition().y,
            width,
            self.editor.gridHeight,
            self.object.__dict__[self.__popupAttr])

        self._popup_editor.SetFocus()

      else:
        # Signal the Properties dialog
        self.editor._instance.dispatchEvent('Show:Tool:objectProperties')


  #
  # Resize the current widget.  dx and dy are incremental
  # resize units. (e.g, (-1,0) means make the widget one
  # unit smaller than it currently is.
  #
  def relativeResize(self, dx, dy):
    if not (dx or dy):
      return 0

    nx = dx * self.editor.gridWidth
    ny = dy * self.editor.gridHeight

    try:
      self.object.Char__height
    except: 
      self.object.Char__height = 1

    if (self.object.Char__width + dx < 0 or self.object.Char__height + dy < 0):
      return 0
    else:
      for widget in self.mainWidget.widgets:
        x,y = widget.GetSizeTuple()
        widget.SetSize(wxSize(x + nx,y + ny))

      oldVals = {}
      newVals = {}
      if dx:
        oldVals['Char:width'] = self.object.Char__width
        self.object.Char__width = self.object.Char__width + dx
        newVals['Char:width'] = self.object.Char__width
      if dy:
        oldVals['Char:height'] = self.object.Char__height
        self.object.Char__height = self.object.Char__height + dy
        newVals['Char:height'] = self.object.Char__height

      self.editor.dispatchEvent('ObjectModified', object=self.object,
                                  originator="Forms::LayoutEditor",
                                  old=oldVals,
                                  new=newVals)

      self.recalcBoundaries()


  #
  # Move the current widget. dx and dy are increments.
  # (e.g., (-1,-2) means move the object up one unit
  # and left two units.
  #
  def relativeMove(self, dx, dy):
    if not (dx or dy):
      return 0

    nx = dx * self.editor.gridWidth
    ny = dy * self.editor.gridHeight

    if (self.object.Char__x + dx < 0 or self.object.Char__y + dy < 0):
      return 0
    else:
      for widget in self.mainWidget.widgets:
        x,y = widget.GetPositionTuple()
        widget.SetPosition(wxPoint(x + nx,y + ny))
      oldVals = {}
      newVals = {}
      if dx:
        oldVals['Char:x'] = self.object.Char__x
        self.object.Char__x += dx
        newVals['Char:x'] = self.object.Char__x
      if dy:
        oldVals['Char:y'] = self.object.Char__y
        self.object.Char__y +=  dy
        newVals['Char:y'] = self.object.Char__y

      self.editor.dispatchEvent('ObjectModified', object=self.object,
                                  originator="Forms::LayoutEditor",
                                  old=oldVals,
                                  new=newVals)

      self.recalcBoundaries()

  #
  # Recursively destroy this widget set
  #
  def Destroy(self):

    # TODO: Why the fsck can't I Destroy() this thing!?!??!?
    self.widget.Show(0)

    self.editor = None
    self.object = None
    self.highlightBox.Destroy()
    self.highlightBox = None
    self._popup_editor = None
    self.widget = None
    self.mainWidget = None
