#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# schema/VisualTable.py
#
# DESCRIPTION:
# The visual representation of a table for Designer (Schema part)
#
# NOTES:
#

from wxPython.wx import *

class VisualTable:
  def __init__(self, tableinstance):
    self.instance=tableinstance
    self._type='VisualTable'
    #self.font = wxFont(self.textSize, wxDEFAULT, wxNORMAL,wxNORMAL,0,fontname )
    self.pen = wxBLACK_PEN # wxPen(...)
    self.pen_highlighted = wxPen(wxBLUE, 1, wxSOLID)
    self.brush = wxWHITE_BRUSH # wxTRANSPARENT_BRUSH # wxBLACK_BRUSH
    self.pen_inv = wxWHITE_PEN # wxPen(...)
    self.brush_inv = wxBLACK_BRUSH # wxTRANSPARENT_BRUSH # wxBLACK_BRUSH
    self.xpos=-100    
    self.ypos=-100
    self.width=10
    self.height=10
    self.textheight=10
    
  
  def calculateDimensions(self,dc):
    (w,h)=dc.GetTextExtent(self.instance.name)
    self.width=w
    self.height=h
    self.textheight=h
    fields=self.instance.findChildOfType('GSFields')
    if fields!=None:
      for c in fields._children:
        (w,h)=dc.GetTextExtent(c.name)
        if w>self.width:
          self.width=w
        self.height=self.height+5+h

    # add some space for the borders
    self.height=self.height+40
    self.width=self.width+20
            
    return (self.width,self.height)

  def recalculateDimensions(self,dc):
    (w,h)=dc.GetTextExtent(self.instance.name)
    self.width=w
    self.height=h
    self.textheight=h
    fields=self.instance.findChildOfType('GSFields')
    if fields!=None:
      for c in fields._children:
        (w,h)=dc.GetTextExtent(c.name)
        if w>self.width:
          self.width=w
        self.height=self.height+5+h

    # add some space for the borders
    self.height=self.height+40
    self.width=self.width+20
            
    return (self.width,self.height)

  def moveTo(self,x,y):
    self.xpos=x
    self.ypos=y

  def drawMe(self,dc,current,inverse=false):
      if inverse: 
        dc.SetPen(self.pen_inv) 
        dc.SetBrush(self.brush_inv)
      else:
        dc.SetPen(self.pen) 
        dc.SetBrush(self.brush)

      dc.DrawRectangle(self.xpos,self.ypos,self.width,self.height)
      dc.DrawLine(self.xpos,self.ypos+self.textheight+20,
                  self.xpos+self.width,self.ypos+self.textheight+20)
      dc.DrawLine(self.xpos,self.ypos+self.textheight+24,
                  self.xpos+self.width,self.ypos+self.textheight+24)

      # dc.SetFont(self.font)
      dc.DrawText(self.instance.name,self.xpos+10,self.ypos+10)
      y=self.ypos+34
      fields=self.instance.findChildOfType('GSFields')
      if fields!=None:
        for c in fields._children:
        
          # check if this field is the current selected object
          if c==current:
            dc.SetPen(self.pen_highlighted)
            dc.SetBrush(wxTRANSPARENT_BRUSH)
            dc.DrawRectangle(self.xpos+3,y+8,self.width-6,self.textheight+4)
          
          dc.DrawText(c.name,self.xpos+10,y+10)
          y=y+self.textheight+5

      # check if the table is selected
      if self.instance==current:
        dc.SetPen(self.pen_highlighted)
        dc.SetBrush(wxTRANSPARENT_BRUSH)
        dc.DrawRectangle(self.xpos+3,self.ypos+8,
                         self.width-6,self.textheight+4)


  # return pointer to field/table object depending on position
  def getObjectAt(self,x,y):
    if x>=self.xpos and x<=self.xpos+self.width and \
           y>=self.ypos and y<=self.ypos+self.height:
      
      # cursor in upper part  -> return table
      hy=self.ypos+34
      if y<hy:
        return self.instance
      
      # cursor in the middle  -> return fields
      fields=self.instance.findChildOfType('GSFields')
      if fields!=None:
        for c in fields._children:        
          hy=hy+self.textheight+5
          if y<hy:
            return c
        
      # cursor at the bottom part ->  return table
      return self
      return self.instance
    
    else:
      return None

  # return pointer to field/table object depending on position
  def isInRectangle(self,x,y,x2,y2):    
    if (not (x>self.xpos+self.width or x2<self.xpos)) and \
       (not (y>self.ypos+self.width and y2<self.ypos)):
      return true
    else:
      return false
    
