#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# reports/Incubator.py
#
# DESCRIPTION:
# Creates objects to be added to the object
#
# NOTES:
#

from gnue.common.apps import GDebug
from gnue.common.definitions import GParserHelpers
from gnue.reports.base import GRParser, GRReport
from gnue.reports.base import layout as GRLayout
from gnue.designer.base.Incubator import BaseIncubator

class Incubator(BaseIncubator):

  elements = GRParser.getXMLelements()

  def createObject(self, rootObject, tag, parent, attributes={}, select=1):
    # Handle GRPassThru
    if tag.find(':')+1:
      o = self._handlePassThru(rootObject, tag, parent, attributes, select)
      if o:
        self.instance.dispatchEvent('ObjectCreated',object=o, originator=__name__)
        if select:
          self.instance.dispatchEvent('ObjectSelected',object=object, originator=__name__)
      return o
    else:
      return BaseIncubator.createObject(self, rootObject, tag, parent, attributes, select)


  def _handlePassThru(self, rootObject, tag, parent,
           attributes={}, select=1):
    # handle <out:region name="primary"> when
    # xmlns:out="GNUe:Reports:Labels"
    try:
      name = attributes['name']
    except KeyError:
      name = tag[tag.find(':')+1:]

    objclass = GRLayout.GRPassThru
    o = objclass(parent)

    # Add any GContent
    try:
      GParserHelpers.GContent(o, attributes['_content_'])
    except KeyError:
      pass

    o.__dict__.update(attributes)
    o._xmltag = tag[tag.find(':')+1:]
    o._listedAttributes = attributes.keys()
    o._xmlnamespace = rootObject.findChildOfType('GRLayout')._xmlchildnamespace

    o.name = name
    self.instance.nameMappings[o.name] = o
    o._buildObject()
    return o
