#
# Copyright 2002-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# LayoutEditor.py
#
# DESCRIPTION:
#
# NOTES:


import sys, os, cPickle, string
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.apps import RuntimeSettings
from gnue.designer.base.ToolBase import ToolBase

class LayoutEditor (ToolBase):

  runtime_section = 'ProcessVisualEditor'

  def init(self):

    self.splitter = wxSplitterWindow(self, -1)

    self.tree = MasterTreeView(self, self.splitter)
    self.list = ObjectEditor(self, self.splitter)

    self.splitter.SplitHorizontally(self.tree, self.list,100)

    self.finalize = 1
    EVT_SIZE(self, self.OnSize)

    rootObject.walk(self.inventoryObject)
    self.tree.postInit()


    # EventAware provided by ToolBase
    self.registerEventListeners({
                       'ObjectSelected'      : self.onSetCurrentObject,
                       'ObjectCreated'       : self.onCreateObject,
                       'ObjectModified'      : self.onModifyObject,
                       'ObjectDeleted'       : self.onDeleteObject,
                      })

  def inventoryObject(self, object):
    self.tree.inventoryObject(object)

  def onSetCurrentObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      pass


  def onCreateObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      pass


  def onModifyObject (self, event):
    object = event.object
    handler = event.originator
    modifications = event.modifications
    if object == None:
      return
    if handler != __name__:
      pass


  def onDeleteObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      pass


  #
  #  Used by RuntimeSettings
  #
  def saveRuntimeSettings(self):
    x, y = self.GetPositionTuple()
    width, height = self.GetSizeTuple()
    return ( self.runtime_section,
             { 'sash': self.splitter.GetSashPosition() } )


  def OnSize(self, event):

    self.splitter.SetSize(self.GetSize())

    if self.finalize:
      self.finalize = 0
      self.splitter.SetSashPosition(\
          RuntimeSettings.getint(self.runtime_section,'sash',100))


############################################################################
#
#
#
class MasterTreeView(wxTreeCtrl):

  def __init__(self, editor, parentWindow):
    wxTreeCtrl.__init__(self, parentWindow, -1,
       style=wxTR_HAS_BUTTONS|wxTR_EDIT_LABELS|wxTR_HAS_VARIABLE_ROW_HEIGHT)

    self.editor = editor

    self.editor.rootObject._treeItem = self.AddRoot( \
         hasattr(self.editor.rootObject,'description') and \
         self.editor.rootObject.description or 'Processes')

    self.SetPyData(self.editor.rootObject._treeItem, self.editor.rootObject)

    EVT_TREE_BEGIN_LABEL_EDIT(self, self.GetId(), self.OnBeginEdit)
    EVT_TREE_END_LABEL_EDIT(self, self.GetId(), self.OnEndEdit)


  def getName(self, object, includeDescr):

    if hasattr(object,'description') and object.description != None:
      description = object.description
      if includeDescr:
        if object._type == 'GNProcess':
          description += ' [sub-process]'
        elif object._type == 'GNStep':
          description += ' [%s]' % object.type
    else:
      description = '(%s)'%object._type[2:]

    return description


  def inventoryObject(self, object):
    if object._type == 'GNParameter':
      return
    if object._parent != None:

      description = self.getName(object, 1)

      object._treeItem = self.AppendItem(object._parent._treeItem, description)
      self.SetPyData(object._treeItem, object)
      if object._type == 'GNProcess':
        self.SetItemBold(object._treeItem,1)


  def postInit(self):
    self.editor.rootObject.walk(self.__expand)


  def __expand(self, object):
    if hasattr(object,'_treeItem') and self.ItemHasChildren(object._treeItem):
      self.Expand(object._treeItem)


  def OnBeginEdit(self, event):
    object = self.GetPyData(event.GetItem())
    if object == self.editor.rootObject:
      event.Veto()
      return
    else:
      self.SetItemText(object._treeItem,self.getName(object,0))


  def OnEndEdit(self, event):
    object = self.GetPyData(event.GetItem())
    object.description = event.GetLabel()
    # TODO: Change to new struct
##    self.editor.instance.onModifyObject(self, object, __name__)
    self.SetItemText(object._treeItem, self.getName(object,1))
    event.Veto()


############################################################################
#
#
#
class ObjectEditor(wxListCtrl):

  def __init__(self, editor, parentWindow):
    wxListCtrl.__init__(self, parentWindow, -1)
    self.editor = editor


