#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# forms/wizards/AddBox.py
#
# DESCRIPTION:
# Implements a basic form template
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string


class AddBoxWizard(FormPrePositioningTemplate):



  ###############
  #
  # Initialize any runtime variables
  #
  def StartWithPositioning(self, root, current,
           x=0, y=0, width=10, height=4):
    self.form = root
    self.current = current
    self.x = x
    self.y = y
    self.width = width
    self.height = height



  ###############
  #
  # We have all the data, so generate our widget.
  #
  def Finalize(self):


    # Create element
    self.AddElement( 'box',
                     self.current['page'],
                     { 'name': self.GetUniqueName('Box1'),
                       'label': 'I am a Box',
                       'Char:x': self.x,
                       'Char:y': self.y,
                       'Char:width': self.width > 2 and self.width or 10,
                       'Char:height': self.height > 2 and self.height or 4})

    return 1



############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    'BaseID' : 'AddBox',
    'BaseClass' : AddBoxWizard,
    'Name' : 'Add Box',
    'Description' : 'Inserts a basic box',
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': TEMPLATE,
    'MenuLocation' : ('Insert',_('Box'), 401.2)
}

