#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# forms/events/Resize.py
#
# DESCRIPTION:
# Code to handle the auto-resize event
#
# NOTES:
#

class Resize:
  def __init__(self, instance):
    self.instance = instance
    self.enabled = 1
    instance.registerEventListeners( {
       'Forms:AutoResizePage':      self.resizeGrid } )

  def _isStandalonePage(self, page):
    return hasattr(page, 'style') and page.style in ('popup',)

  def resizeGrid(self, event):
    if self._isStandalonePage(self.instance.visualEditor.page):
      target = self.instance.layoutEditor.page
      stack = [target]
    else:
      target = self.instance.rootObject._layout
      stack = []
      for object in target._children:
        if not self._isStandalonePage(object):
          stack.append(object)

    mx = 0
    my = 0

    while stack:
      object = stack.pop()
      for child in object._children:
          stack.insert(0,child)
      try:
        x = object.Char__x
      except AttributeError:
        continue

      try:
        y = object.Char__y
      except AttributeError:
        y = 0

      try:
        h = object.Char__height
      except AttributeError:
        h = 1

      try:
        w = object.Char__width
      except AttributeError:
        try:
          w = len(object.text)
        except AttributeError:
          w = 10

      mx = max(mx, x + w)
      my = max(my, y + h)

    if not (my or mx):
      return

    if not my: my = 12
    if not mx: mx = 40

    new = {}
    old = {}
    if mx != target.Char__width:
      old['Char:width'] = target.Char__width
      new['Char:width'] = target.Char__width = mx

    if my != target.Char__height:
      old['Char:height'] = target.Char__height
      new['Char:height'] = target.Char__height = my

    self.instance.dispatchEvent('ObjectModified', originator=self,
        old=old, new=new, object=target)
