#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# form/WizardRunner.py
#
# DESCRIPTION:
# Runs a form "wizard"
#
# NOTES:
# Adds Prepositioning Template support to the base WizardRunner
#

from gnue.designer.base.TemplateParser import WizardRunner as BaseWizardRunner
import TemplateSupport
from gnue.common.events import Event

# We subclass the main WizardRunner to add
# prepositioning support (i.e., select coordinates
# before the wizard begins.)
class WizardRunner(BaseWizardRunner):

  def run(self, event):
    # Handle FormPrePositioningTemplate specially;
    # i.e., intercept the run method.
    if issubclass( self.template['BaseClass'],
                   TemplateSupport.FormPrePositioningTemplate ):
      self.instance.dispatchEvent('BeginWizard',
                template=self.template)
      self.prepositioning = 1
      event.dispatchAfter('LayoutEditor:Prepositioning', wizardrunner=self)
    else:
      self.prepositioning = 0
      BaseWizardRunner.run(self, event)

  def positioned_run(self, *args, **parms):
    self.prepositioning = 0
    BaseWizardRunner.run(self, None, *args, **parms)

  def cancel(self, event=None):
    if hasattr(self,'prepositioning') and self.prepositioning:
      self.instance.dispatchEvent('Cancel:LayoutEditor:Prepositioning')
      self.instance.dispatchEvent('EndWizard', template=self.template)
    else:
      BaseWizardRunner.cancel(self)
