#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# TreeView.py
#
# DESCRIPTION:
#
# NOTES:
#
# TODO: * all the SetItemImage lines in this file have been commented
#         out as on win32 it was segfaulting
#       * make TreeView more stable, at the moment it fires OnTreeItemSelected
#         events while beeing destroyed, which is causing segfaults on wxPy<2.3
#         (wxPy 2.3 raises exceptions) when TreeView is not the first tool to
#         be removed

import sys, os
from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.common.logic import GTrigger
from gnue.forms import GFForm, GFObjects, GFLibrary
from gnue.designer.base.PopupMenu import ObjectMenu
from gnue.designer.base.Icons import treeIconMap, treeIconList
from gnue.designer.base.ToolBase import *

class TreeView (ToolBase):

  default_dock = 'left-0'

  def init(self):

    # EventAware provided by ToolBase
    self.registerEventListeners({
                       'ObjectSelected'      : self.onSetCurrentObject,
                       'ObjectCreated'       : self.onCreateObject,
                       'ObjectModified'      : self.onModifyObject,
                       'ObjectDeleted'       : self.onDeleteObject,
                      })

    self.panel = wxPanel(self,-1,style=wxSIMPLE_BORDER, pos=wxPoint(6,6))
    EVT_SIZE(self, self.onSize)

    self.tree = wxTreeCtrl(self.panel, wxNewId(),
       style=wxTR_HAS_BUTTONS|#wxTR_EDIT_LABELS|
           wxTR_FULL_ROW_HIGHLIGHT)#|wxTR_HIDE_ROOT)
    self._handler = None

    self.tree.SetImageList(treeIconList)

    EVT_TREE_BEGIN_LABEL_EDIT(self, self.tree.GetId(), self.OnTreeLabelEdit)
    EVT_TREE_END_LABEL_EDIT(self, self.tree.GetId(), self.OnTreeLabelEditEnd)
    EVT_TREE_SEL_CHANGED(self, self.tree.GetId(), self.OnTreeItemSelected)

    root = self.rootObject._treeItem = self.tree.AddRoot(self.rootDescr)
    self.tree.SetPyData(self.rootObject._treeItem, self.rootObject)

    EVT_RIGHT_DOWN(self, self.OnRightDown)
    EVT_LEFT_DCLICK(self, self.OnEditProperties)

    self.inittree()
    self.rootObject.walk(self.inventoryObject)
    self.tree.Expand(root)
    self.Fit()

  # For use by subclasses
  def inittree(self):
    pass

  # For use by subclasses
  def inventoryObject(self):
    pass

  def onSize(self, event):
    x,y = self.GetClientSizeTuple()
    self.panel.SetSize((x-12,y-12))
    self.tree.SetSize(self.panel.GetClientSizeTuple())

  def AppendItem(self, parent, description):
    rv = self.tree.AppendItem(parent, description)
    return rv

  def onSetCurrentObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      self.tree.EnsureVisible(object._treeItem)
      self._handler = handler
      self.tree.SelectItem(object._treeItem)
      self._handler = None

  def onCreateObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      try:
        GDebug.printMesg(4,"Adding %s (%s)" % (object.name, object._type))
      except:
        pass
      self.inventoryObject(object)

  def onModifyObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if handler != __name__:
      for attribute in event.new.keys():
        value = event.new[attribute]
        if attribute == 'name' and object != self.rootObject:
          self.tree.SetItemText(object._treeItem, object.getDescription())

  def onDeleteObject (self, event):
    object = event.object
    handler = event.originator
    if object == None:
      return
    if hasattr(object, '_treeItemTrigger'):
      self.tree.Delete(object._treeItemTrigger)
    if hasattr(object, '_treeItem'):
      if self.tree.GetSelection() == object._treeItem:
        self.tree.SelectItem(self.tree.GetItemParent(object._treeItem))
      self.tree.Delete(object._treeItem)
    self.Refresh()

  def OnTreeLabelEdit(self, event):
    event.Veto()

  def OnTreeLabelEditEnd(self, event):
    pass

  def OnTreeItemSelected(self, event):
    if self._handler == None:
      object = self.tree.GetPyData(event.GetItem())
      if object != None and not isinstance(object, ObjectMenu):
        self.dispatchEvent('ObjectSelected', object=object, originator=__name__)
      else:
        self.dispatchEvent('ObjectSelected', object=None, originator=__name__)

  def OnRightDown(self, event):
    id, flags = self.tree.HitTest(event.GetPosition())
    object = self.tree.GetPyData(id)
    self.tree.EnsureVisible(id)
    self.tree.SelectItem(id)
    if isinstance(object, ObjectMenu):
      self.PopupMenu(object, event.GetPosition())
    elif object != None:
      self.PopupMenu(object._popupMenu, event.GetPosition())


  def OnEditProperties(self, event):

    id, flags = self.HitTest(event.GetPosition())
    object = self.tree.GetPyData(id)
    self.tree.EnsureVisible(id)
    self.tree.SelectItem(id)
    if not isinstance(object, ObjectMenu):
      self.instance.propertyEditorWindow.Show(1)
      self.instance.propertyEditorWindow.Raise()
      self.instance.propertyEditorWindow.SetFocus()


