#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# ToolPanel.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['BasePane']

from wxPython.wx import *

class BasePane:
  def __init__(self, parent, instance, tool):
    self.parent = parent
    self.instance = instance
    self.tool = tool

    # Reparent the tool to be under our control...
    tool.Reparent(self)
    tool.dockpane = self

  def show(self):
    pass

  def hide(self):
    pass

  def setFeedback(self, text):
    pass

  def closing(self):
    pass

