#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# TemplateChooser.py
#
# DESCRIPTION:
# Prompts user for template/wizard to run
#
# NOTES:

from wxPython.wx import *
from gnue.common.apps import GDebug
from gnue.designer.base import TemplateBase
from gnue.designer.templates import GetAvailablePackages, GetAvailableTemplates

class TemplateChooser:
  def __init__(self, parent):
    self.parent = parent

    self.packages = GetAvailablePackages()


  def run(self):

    self.chooser = wxDialog(None, -1, _('Choose Wizard to Run...'),
       style=wxDEFAULT_DIALOG_STYLE|wxDIALOG_MODAL)


    self.panel = wxPanel(self.chooser, -1, wxPoint(0,0), wxSize(400,340))
    self.notebook = wxNotebook(self.panel, -1)
    self.chooser.SetClientSize(wxSize(400,340))

    self.chooseButton = wxButton(self.panel, -1, _('Run Wizard'))
    self.cancelButton = wxButton(self.panel, -1, _('Cancel'))

    self.chooseButton.SetDefault()

    self.cancelButton.SetSize(self.chooseButton.GetSize())

    y = self.panel.GetClientSize().y - 6 - self.chooseButton.GetSize().y
    dx = self.chooseButton.GetSize().x + 6
    x = self.panel.GetClientSize().x - 9 - self.chooseButton.GetSize().x

    self.cancelButton.SetPosition( (x, y) )
    self.chooseButton.SetPosition( (x - dx, y) )


    EVT_BUTTON(self.chooser,self.chooseButton.GetId(), self.OnSelected)
    EVT_BUTTON(self.chooser,self.cancelButton.GetId(), self.OnCancel)

    EVT_CLOSE(self.chooser, self.OnCancel)

#    self.title = wxStaticText(self.panel, -1, "Wizard Header", pos=wxPoint(10,10))
#    font = self.title.GetFont()
#    font.SetPointSize(int(self.title.GetFont().GetPointSize()*1.5))
#    font.SetStyle(wxITALIC)
#    self.title.SetForegroundColour(wxColour(255,255,255))
#    self.title.SetFont(font)
#    self.title2 = wxStaticText(self.panel, -1, "Wizard Header", pos=wxPoint(11,11))
#    self.title2.SetForegroundColour(wxColour(0,0,102))
#    self.title2.SetFont(font)

    self.chooser.Fit()

    self.notebook.SetPosition((10, 10))
    w,h = self.chooser.GetClientSizeTuple()
    w = w - 21
    h = h - 46 - self.chooseButton.GetSize().y
    self.notebook.SetSize((w,h))

#    self.chooserPage.SetSize((w,h))
#    self.chooserPage.SetBackgroundColour(
#        wxColour(
#          self.panel.GetBackgroundColour().Red() + 32,
#          self.panel.GetBackgroundColour().Green() + 32,
#          self.panel.GetBackgroundColour().Blue() + 32) )

    GDebug.printMesg(2,"Packages=%s" % self.packages)
    notebookIndex = 0
    lookupIndex = 0
    self.lookup = {}
    for package in self.packages:
#      page = wxPanel(self.notebook, -1, wxPoint(0,0), \
#                     self.notebook.GetClientSize())
#      w,h = page.GetClientSizeTuple()
#      ctrl = wxListCtrl(page, -1,wxPoint(5,5), wxSize(w-10,h-10),
#                   style=wxLC_REPORT|wxLC_SINGLE_SEL|wxSTATIC_BORDER) #wxLC_HRULES|wxLC_VRULES|)
      ctrl = wxListCtrl(self.notebook, -1,wxPoint(5,5), wxSize(w-10,h-10),
                   style=wxLC_REPORT|wxLC_SINGLE_SEL|wxSTATIC_BORDER) #wxLC_HRULES|wxLC_VRULES|)
      ctrl.InsertColumn(0, _("Name"), format=wxLIST_FORMAT_LEFT, width=-1)
      ctrl.InsertColumn(1, _("Description"), format=wxLIST_FORMAT_LEFT, width=-1)
      ctrl.InsertColumn(2, _("Type"), format=wxLIST_FORMAT_LEFT, width=-1)
      ctrl.InsertColumn(3, _("Author"), format=wxLIST_FORMAT_LEFT, width=-1)
      ctrl.InsertColumn(4, _("Version"), format=wxLIST_FORMAT_LEFT, width=-1)

      EVT_LIST_ITEM_SELECTED(self.chooser, ctrl.GetId(), self.OnSelect)
      EVT_LIST_ITEM_ACTIVATED(self.chooser, ctrl.GetId(), self.OnSelected)

#      self.notebook.AddPage(page, package.PACKAGE)
      self.notebook.AddPage(ctrl, package.PACKAGE)
      self.lookup[notebookIndex] = {}


      i = 0
      for template in GetAvailableTemplates(package):
        ctrl.InsertStringItem(i, template['Name'])
        if template.has_key('Description'):
          ctrl.SetStringItem(i, 1, template['Description'])
        else:
          ctrl.SetStringItem(i, 1, _('Unknown'))

        if template['Product'] == TemplateBase.TEMPLATE:
          ctrl.SetStringItem(i, 2, 'Template')
        elif template['Product'] == TemplateBase.WIZARD:
          ctrl.SetStringItem(i, 2, _('Wizard'))

        if template.has_key('Author'):
          ctrl.SetStringItem(i, 3, template['Author'])
        else:
          ctrl.SetStringItem(i, 3, _('Unknown'))

        if template.has_key('Version'):
          ctrl.SetStringItem(i, 4, template['Version'])
        else:
          ctrl.SetStringItem(i, 4, _('Unknown'))
        ctrl.SetItemData(i, lookupIndex)

        self.lookup[notebookIndex][lookupIndex] = template

        i += 1
        lookupIndex += 1

      if i:
        ctrl.SetColumnWidth(0,wxLIST_AUTOSIZE)

      lookupIndex = 0
      notebookIndex += 1


    self.selection = 0
    completed = self.chooser.ShowModal()
    results = None

    if completed:
      results = self.lookup[self.notebook.GetSelection()][self.selection]

    self.chooser.Destroy()
    return results

  # When user highlights a wizard from the list...
  def OnSelect(self, event):
    self.selection = event.GetIndex()

  # When user clicks the "Select" button...
  def OnSelected(self, event):
    self.chooser.EndModal(1)

  # When user clicks the "Cancel" button...
  def OnCancel(self, event):
    self.chooser.EndModal(0)
