#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# LayoutEditor.py
#
# DESCRIPTION:
#
# NOTES:


from gnue.designer.base.ToolBar import BaseToolBar

ToolbarMapping = 'RequestNewForm,tb_new,pulldown;'   \
               + 'RequestOpen,tb_open,pulldown;' \
               + 'RequestSave,tb_save;' \
               + 'RequestSaveAs,tb_save_as;' \
               + ';' \
               + 'RequestExit,tb_exit;'


class PrimaryToolBar(BaseToolBar):

  def init(self):
    self.registerEventListeners( {'MakeDirty' : self.onDirty,
                                  'MakeClean' : self.onClean, } )
    self.addToolbarMapping(ToolbarMapping)


  def onDirty(self, event):
    try:
      self.EnableTool(self.mapping['RequestSave'],1)
    except KeyError:
      pass


  def onClean(self, event):
    try:
      self.EnableTool(self.mapping['RequestSave'],0)
    except KeyError:
      pass
