#!/usr/bin/env python
#
# GNU Enterprise Designer - Installation Procedure
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py,v 1.55 2003/10/06 18:39:27 reinhard Exp $

import sys
import os

from src import PACKAGE, VERSION

try:
  from gnue.common.setup import GSetup
except ImportError:
  print "You need GNUe-Common 0.5.2 or newer installed to install %s" % PACKAGE
  sys.exit (1)

# =============================================================================

class setup (GSetup.GSetup):

  package = PACKAGE.lower()

  # ---------------------------------------------------------------------------
  # Definition of basic parameters for distribution and installation.
  # Please add new files/directories that should be installed here.
  # Note that you also have to add them to MANIFEST.in.
  # ---------------------------------------------------------------------------

  def set_params (self, params):
  
    # The Work
    params ["name"]             = PACKAGE
    params ["version"]          = VERSION
    params ["description"]      = "GNU Enterprise Designer"
    params ["long_description"] = ""
    params ["license"]          = "GPL"

    # The Author
    params ["author"]       = "GNU Enterprise Team"
    params ["author_email"] = "gnue-dev@gnu.org"
    params ["url"]          = "http://www.gnue.org"

    # The Programs
    params ["package_dir"] = {"gnue.designer": "src"}
    params ["scripts"]     = ["scripts/gnue-designer"]

    # The Data
    imagefiles  = self.allfiles ("images")
    man1files   = ["doc/man/gnue-designer.1"]
    docfiles    = self.allfiles ("doc")

    params ["data_files"] = \
      [("share/gnue/images/designer", imagefiles),
       ("share/man/man1",             man1files),
       ("share/doc/gnue-designer",    docfiles)]

  # ---------------------------------------------------------------------------
  # Build files to be distributed and installed:
  # Should generate the files that go in a distribution but aren't in SVN.
  # Gets called on sdist (always) and on build/install (only when run from SVN).
  # ---------------------------------------------------------------------------

  def build_files (self, action):
    # nothing to do here
    pass

  # ---------------------------------------------------------------------------
  # Check dependencies for installation:
  # Should sys.exit(1) in case any requirement isn't met.
  # Gets called on install.
  # ---------------------------------------------------------------------------

  def check_dependencies (self):

    # -------------------------------------------------------------------------
    # Verify at least one UI is installed
    UIOK = 0

    # wxPython
#   print "checking wxPython library"
#   try:
#     import wxPython
#     UIOK = 1
#   except ImportError:
#     pass
    UIOK = 1    # FIXME: wxPython import also fails when we don't run under X

    if UIOK != 1:
      print "---"
      print """
No valid UI drivers are installed on this machine.
Please install one of the following packages:
  wxPython      - www.wxpython.org
The file 'INSTALL' contains more information about dependencies.
"""
      sys.exit (1)

# =============================================================================

if __name__ == "__main__":
  setup().run()
