#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# GParserHelpers.py
#
# DESCRIPTION:
# Class that holds GNUe Parser helper classes
#
# NOTES:
#
# HISTORY:
#

from xml.sax import saxutils
from types import StringType

#
# Class ParserObj
#
# Common initialization for GParser objects
#
class ParserObj:
  def __init__(self, parent=None, type='_NotSet_'):
    self._type = type
    self._parent = parent       # The object that contains this object
    self._children = []         # The objects contained by this object
    self._attributes = {}
    self._inits = []            # functions called during phaseInit stage
    self._xmlnamespace = None   # If the object is namespace-qualified, the namespace
    self._xmlnamespaces = {}    # If attributes are namespace-qualified, a map
    if parent :
      parent.addChild(self)


#
# Class GContent
#
# Base class for xml content
#
class GContent(ParserObj):

  def __init__(self, parent, content):
    ParserObj.__init__(self, parent, '_content_')
    self._content = content

  def getEscapedContent(self):
    return saxutils.escape(self._content)

  def getContent(self):
    return self._content

  def dumpXML(self, lookupDict, treeDump=None, gap=None,
              escape=1, textEncoding='<locale>', xmlnamespaces={}):
    if textEncoding=='<locale>':
      textEncoding=gConfig('textEncoding')

    if type(self._content) == StringType:
      xmlString = '%s' % unicode(self._content, textEncoding)
    else:
      xmlString = self._content

    if escape:
      return saxutils.escape(xmlString)
    else:
      return xmlString


  def showTree(self, indent=0):
    print ' '*indent + 'GContent ' + `self._content`

  #def _type(self):
  #  return "_content_"

  #
  # getDescription
  #
  # Return a useful description of this object
  # Used by designer clients
  #
  def getDescription(self):
    return "(Content)"
