#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('view',_('Views'),1),
           ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects
  #
  # Schema (metadata) functions
  #

  # TODO: See postgresql for an example of what these functions do.

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    return []

  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    return None
