#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# static/Connection.py
#
# DESCRIPTION:
# Basic connection object for static datasources
#
# NOTES:
#

__all__ = ['Connection']

from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources.GDataObjects import *
from DataObject import *

####                                   ####
#### IF YOU MODIFY ANY CONNECTION      ####
#### ATTRIBUTES, PLEASE UPDATE info.py ####
####                                   ####

class Connection(Connection):

  # TODO: do we have/need Introspection?
  #defaultBehavior = Introspection

  supportedDataObjects = {
    'object': STATIC_DataObject
  }

  # We don't do logins
  def getLoginFields(self):
    return ()

  # We don't do connections (we are connectionless)
  def connect(self, connectData={}):
    # build field list
    self._fieldReferences=string.split(self._staticSet.fields,",")

    self._postConnect()



