#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# dcoracle/__init__.py
#
# DESCRIPTION:
"""
Oracle implementation of dbdriver using Python DB-SIG v2
specification.
"""
# NOTES:
#

__description__ = _("DCOracle2 Data Driver for Oracle 7.3/8i/9i+ (OCI8)")
__driverurl__ = "http://www.zope.org/Products/DCOracle2/"
__examples__ = """
   Supported attributes (via connections.conf or <connection> tag)

     service=    This is the Oracle TNS name for your connection  (required)
"""
__doc__ = ""

# Test if plugin is functional
def __initplugin__ ():
  import Driver

#
# Stub code to not initialize the Connection until needed.
# This greatly helps with error messages.
#
def Connection(*args, **parms):
  from Driver import Connection as C
  return C(*args, **parms)

