#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('view',_('Views'),1),
           ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects
  #
  # Schema (metadata) functions
  #
  def getSchemaList(self, type=None):

    statement = "select * from __table_names__"

    cursor = self._connection.native.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)

    list = []
    for rs in cursor.fetchall():
      # exclude any system tables and views. f.e. __table_names__
      if rs[1][:2]!="__":
        list.append(GIntrospection.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                'type':rs[0] == 1 and 'view' or 'table',},
                                       getChildSchema=self.__getFieldSchema))

    cursor.close()
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    statement = "SELECT * from __table_names__ WHERE TABLE_NAME='%s'" % (name)

    cursor = self._connection.native.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)

    rs = cursor.fetchone()
    if rs:
      schema = GIntrospection.Schema(attrs={'id':rs[1], 'name':rs[1], \
                                'type':rs[0] == 1 and 'view' or 'table',},
                                       getChildSchema=self.__getFieldSchema)
    else:
      schema = None

    cursor.close()
    return schema


  # Get fields for a table
  def __getFieldSchema(self, parent):

    # TODO: Read whole definitions from __DATADEFS__ and parse them
    #       to distinguish between varchar, float and integer
    
    statement = "SELECT * FROM __COLUMNS__ WHERE TABLE_NAME='%s'" % parent.id

    cursor = self._connection.native.cursor()
    GDebug.printMesg(1,"** Executing: %s **" % statement)
    cursor.execute(statement)
    columns = cursor.description

    list = []
    for rs in cursor.fetchall():

      #nativetype = string.split(string.replace(rs[1],')',''),'(')


      attrs={'id': "%s.%s" % (parent.id, rs[0]), 'name': rs[0],
             'type':'field', 'nativetype': 'varchar',
             'required': 0}

      #if nativetype[0] in ('int','integer','bigint','mediumint',
      #                     'smallint','tinyint','float','real',
      #                     'double','decimal'):
      #  attrs['datatype']='number'
      #elif nativetype[0] in ('date','time','timestamp','datetime'):
      #  attrs['datatype']='date'
      #else:
      #  attrs['datatype']='text'

      ## MORE EVILNESS
      attrs['datatype']='text'
      ##END HACK
      
      #try:
      #  if len(nativetype) == 2:
      #    attrs['length'] = int(string.split(nativetype[1])[0])
      #except ValueError:
      #  GDebug.printMesg(1,'WARNING: mysql native type error: %s' % nativetype)

      list.append(GIntrospection.Schema(attrs=attrs))

    cursor.close()
    return list

