#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('view',_('Views'),1),
           ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects
  # Return a list of Schema objects
  #

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    tablename=self._connection.native.fname
    if tablename[-4:]=='.csv':
        tablename=tablename[:-4]

    list = [GIntrospection.Schema(attrs={'id':tablename,\
                          'name':tablename, \
                          'type':'table'},\
                   getChildSchema=self.__getFieldSchema)]
    return list


  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):
    schema = GIntrospection.Schema(attrs={'id':name, 'name':name,\
                         'type':'table'},\
                         getChildSchema=self.__getFieldSchema)
    return schema

  # Get fields for a table
  def __getFieldSchema(self, parent):

    list = []
    print self._connection.native.fieldnames
    for field in self._connection.native.fieldnames:

      fname=string.lower(field)

      attrs={'id': "%s.%s" % (parent.id,fname),
                'name': fname,
                'type':'field',
                'nativetype': 'text',
                'required': 0}
      attrs['datatype']='text'
      attrs['length']='20'

      list.append(GIntrospection.Schema(attrs=attrs))

    return list

