# GNU Enterprise Datasource Library - Driver for GNUe-AppServer
#
# Copyright 2000-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: RecordSet.py 5653 2004-04-06 18:14:46Z reinhard $

from gnue.common.datasources.drivers import Base

# =============================================================================
# RecordSet class
# =============================================================================

class RecordSet (Base.RecordSet):
  """
  Handles a record (i.e. an instance) in the GNUe-AppServer backend.
  """
  # ---------------------------------------------------------------------------
  # Initialization
  # ---------------------------------------------------------------------------

  def __init__ (self, parent, sm, session_id, classname, initialData = {}):

    Base.RecordSet.__init__ (self, parent, initialData = initialData)

    self.__sm = sm
    self.__session_id = session_id
    self.__classname = classname

  # ---------------------------------------------------------------------------
  # Delete
  # ---------------------------------------------------------------------------

  def _postDelete (self):

    self.__sm.delete (self.__session_id,
                      self.__classname,
                      [self._fields ['gnue_id']])

  # ---------------------------------------------------------------------------
  # Insert
  # ---------------------------------------------------------------------------

  def _postInsert (self, fields):

    self._fields ['gnue_id'] = self.__sm.store (self.__session_id,
                                                self.__classname,
                                                [None],
                                                fields.keys (),
                                                [fields.values ()]) [0]

  # ---------------------------------------------------------------------------
  # Update
  # ---------------------------------------------------------------------------

  def _postUpdate (self, fields):

    self.__sm.store (self.__session_id,
                     self.__classname,
                     [self._fields ['gnue_id']],
                     fields.keys (),
                     [fields.values ()])

  # ---------------------------------------------------------------------------
  # Call a server-side function
  # ---------------------------------------------------------------------------

  def callFunc (self, methodname, parameters):

    if self.isEmpty ():
      raise gException, u_("Function call for empty record")

    # Before calling the function, post all pending changes to the server
    self.post ()

    return self.__sm.call (self.__session_id,
                           self.__classname,
                           [self._fields ['gnue_id']],
                           methodname,
                           parameters) [0]
