#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or(at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Introspection.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Introspection']

import adodbapi

import string
from string import lower, join, split
import sys

from gnue.common.apps import GDebug, GConfig
from gnue.common.datasources import GIntrospection

DESCRIPTION_NAME            = 0
DESCRIPTION_TYPE_CODE       = 1
DESCRIPTION_DISPLAY_SIZE    = 2
DESCRIPTION_INTERNAL_SIZE   = 3
DESCRIPTION_PRECISION       = 4
DESCRIPTION_SCALE           = 5
DESCRIPTION_NULL_OK         = 6

TABLE_CATALOG = 0
TABLE_SCHEMA = 1 
TABLE_NAME = 2
TABLE_TYPE = 3

adSchemaTables = 20


class Introspection(GIntrospection.Introspection):

  # list of the types of Schema objects this driver provides
  types =[ ('view',_('Views'),1),
           ('table',_('Tables'),1) ]

  #
  # TODO: This is a quick hack to get this class
  # TODO: into the new-style schema format.
  # TODO: getSchema* should be merged into find()
  #
  def find(self, name=None, type=None):
    if name is None:
      return self.getSchemaList(type)
    else:
      rs = self.getSchemaByName(name, type)
      if rs:
        return [rs]
      else:
        return None


  # TODO: Merge into find()
  # Return a list of Schema objects
  #
  # Schema (metadata) functions
  #

  # TODO: See postgresql for an example of what these functions do.

  # Return a list of Schema objects
  def getSchemaList(self, type=None):
    QueryType = adSchemaTables
    rs = self._connection.native.adoConn.OpenSchema(QueryType)

    rs.MoveFirst()
    tables = []
    while not rs.EOF:
      if str(rs.Fields(TABLE_TYPE)) == 'TABLE':
        tables.append((str(rs.Fields(TABLE_NAME)),'table'))
      elif str(rs.Fields(TABLE_TYPE)) == 'VIEW':
        tables.append((str(rs.Fields(TABLE_NAME)),'view'))
      rs.MoveNext()

    list = []
    for t in tables:
      list.append(GIntrospection.Schema(attrs={'id':t[0], 'name':t[0],
                         'type':t[1],
			 'primarykey': self.__getPrimaryKey(t[0])},
                         getChildSchema=self.__getFieldSchema))
    return list

  # Find a schema object with specified name
  def getSchemaByName(self, name, type=None):

    schema = GIntrospection.Schema(attrs={'id':name, 'name':name,
                         'type':'table',
			 'primarykey': self.__getPrimaryKey(name)},
                         getChildSchema=self.__getFieldSchema)
    return schema

  # Return a list of fields (for _buildDeleteStatement and for _buildUpdateStatement)
  def __getPrimaryKey(self, relname):
    # TODO
    return []

  # Get fields for a table
  def __getFieldSchema(self, parent):
    statement = "select * from %s where 0=1" % (parent.name)

    cursor = self._connection.native.cursor()
    cursor.execute(statement)

    list = []

    for d in cursor.description:
      try:
        nativetype = d[DESCRIPTION_TYPE_CODE]
      except AttributeError:
        nativetype='unknown'

      attrs={'id':d[DESCRIPTION_NAME],
                 'name':d[DESCRIPTION_NAME],
                 'type':'field',
                 'nativetype': nativetype,
                 'required': d[DESCRIPTION_NULL_OK]==0,
                 'length': d[DESCRIPTION_INTERNAL_SIZE]}

      if nativetype == adodbapi.NUMBER:
        attrs['datatype']='number'
        attrs['precision']=d[DESCRIPTION_SCALE]
        attrs['length']=d[DESCRIPTION_PRECISION]
      elif nativetype == adodbapi.DATETIME:
        attrs['datatype']='date'
      else:
        attrs['datatype']='text'

      list.append(GIntrospection.Schema(attrs=attrs))

    cursor.close()
    return list


