#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# FocusedLabel.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Label import Label

class FocusedLabel(Label):
  """
    Like a normal label but this can be receive Get/Lost focus and
    Action messages.  What is this used for?  Items like dropdown menus
    and the like.
  """
  def __init__(self, Parent, LabelName, Y, X, Caption, **properties):
    Label.__init__(self, Parent, LabelName, Y, X, Caption, **properties)
    self.CANGETFOCUS = 1
    self.SetMethod("SYSRUN", self.Run)
    self.SetMethod("SYSPAINT", self.Paint)
    self.SetMethod("SYSGOTFOCUS", self.GotFocus)
    self.SetMethod("SYSLOSTFOCUS", self.LostFocus)
    self.SetMethod("CLICK", None)

  def Run(self, v1, v2, v3):
    Container = self.PARENT.Screen()
    if v1 :
      self.ExecMethod("CLICK", self, None, None)
      if self.HasProperty("EXITFORM"):
        if self.EXITFORM:
          return 1
    while 1:
      global BACKWARDS
      ch = Container.GetChar()
      if self.PARENT.BreakOrder(ch) :
        return
      if ch in (Container.TokDownArrow, Container.TokNextField, Container.TokUpArrow):
        BACKWARDS = 0
        if ch == Container.TokUpArrow:
          BACKWARDS = 1
        return
      elif ch == Container.TokActivate:
        self.ExecMethod("CLICK", self, None, None)
        if self.HasProperty("EXITFORM"):
          if self.EXITFORM:
            return 1
        self.ExecMethod("SYSGOTFOCUS", None, None, None)

  def Paint(self, HasFocus, v2, v3):
    gDebug(0,'Workin it')
    Container = self.PARENT.Screen()
    if self.active:
      if HasFocus :
        color = self.FOCUSCOLOR
      else:
        color = self.COLOR
    else:
      color = self.COLOR
    Y = self._ABSY
    X = self._ABSX
    caption = self.CAPTION
    Container.PrintAt(Y,X,caption, color)

  def GotFocus(self, v1, v2, v3):
    self.Paint(1, None, None)
    return 1

  def LostFocus(self, v1, v2, v3):
    self.Paint(0, None, None)
    return 1


