;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  report-gnome.scm
;;  module definition for the gnome report system code 
;;
;;  Copyright (c) 2001 Linux Developers Group, Inc. 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-module (gnucash report report-gnome))
(use-modules (gnucash main)) ;; FIXME: delete after we finish modularizing.
(use-modules (gnucash gnc-module))
(use-modules (gnucash gnome-utils))

(use-modules (ice-9 slib))
(require 'printf)

(use-modules (g-wrapped gw-core-utils))
(use-modules (g-wrapped gw-report-gnome))

(gnc:module-load "gnucash/gnome-utils" 0)
(gnc:module-load "gnucash/report/report-system" 0)
(gnc:module-load "gnucash/report/utility-reports" 0)

(export gnc:report-edit-options)
(export gnc:report-menu-setup)
(export gnc:add-report-template-menu-items)

;; returns a function that takes a list: (options, report),
;; and returns a widget
(define (gnc:report-options-editor report) 
  (if (equal? (gnc:report-type report) "Multicolumn View")
      gnc:column-view-edit-options
      gnc:default-options-editor))

;; do not rely on the return value of this function - it has none.
;; instead, this function's side-effect is to set the report's editor widget.
(define (gnc:report-edit-options report) 
  (let* ((editor-widg (gnc:report-editor-widget report)))
    (if editor-widg
        (gnc:report-raise-editor report)
        (begin
          (if (gnc:report-options report) 
              (begin 
                (set! editor-widg
                      ((gnc:report-options-editor report)
                       (gnc:report-options report)
                       report))
                (gnc:report-set-editor-widget! report editor-widg))
              (gnc:warning-dialog #f (_ "This report has no options.")))))))

(define (gnc:add-report-template-menu-items)
  (define *template-items* '())

  (define (add-template-menu-item name template)
    (if (gnc:report-template-in-menu? template)
        (let ((title (string-append (_ "Report") ": " (_ name)))
              (menu-path (gnc:report-template-menu-path template))
              (menu-tip (gnc:report-template-menu-tip template))
              (item #f))

          ;;(if (not menu-path)
              ;;(set! menu-path '(""))
              ;;(set! menu-path
              ;; (append menu-path '(""))))

          (if (not menu-path)
              (set! menu-path '()))

          (set! menu-path (append (list gnc:menuname-reports) menu-path))

          (if (not menu-tip)
              (set! menu-tip
                    (sprintf #f (_ "Display the %s report") (_ name))))

          (set! item
                (gnc:make-menu-item
                 name
                 menu-tip
                 menu-path
                 (lambda (window)
                   (let ((report (gnc:make-report
                                  (gnc:report-template-name template))))
                     (gnc:main-window-open-report report window)))))
          (gnc:add-extension item))))

  (define (add-template name template)
    (let ((menu-name (gnc:report-template-menu-name template)))
      (if menu-name (set! name menu-name))
      (set! *template-items* (cons (cons name template) *template-items*))))

  (define (sort-templates a b)
    (string>? (car a) (car b)))

  (gnc:report-templates-for-each add-template)
  (for-each
   (lambda (item)
     (add-template-menu-item (car item) (cdr item)))
   (sort *template-items* sort-templates)))

(define (gnc:report-menu-setup)
  (define asset-liability-menu
    (gnc:make-menu gnc:menuname-asset-liability (list gnc:menuname-reports)))
  (define income-expense-menu
    (gnc:make-menu gnc:menuname-income-expense (list gnc:menuname-reports)))
  (define utility-menu
    (gnc:make-menu gnc:menuname-utility (list gnc:menuname-reports)))
  (define custom-menu
    (gnc:make-menu gnc:menuname-custom (list gnc:menuname-reports)))
  (define tax-menu 
    (gnc:make-menu gnc:menuname-taxes (list gnc:menuname-reports)))

  ;; (gnc:add-extension tax-menu)
  (gnc:add-extension income-expense-menu)
  (gnc:add-extension asset-liability-menu)
  (gnc:add-extension utility-menu)
  (gnc:add-extension custom-menu)

  ;; run report-hook danglers
  (gnc:hook-run-danglers gnc:*report-hook*)

  ;; push reports (new items added on top of menu)
  (gnc:add-report-template-menu-items)

  ;; the Welcome to GnuCash "extravaganza" report
  (gnc:add-extension 
   (gnc:make-menu-item 
    (N_ "Welcome Sample Report")
    (N_ "Welcome-to-GnuCash report screen")
    (list gnc:menuname-reports gnc:menuname-utility "")
    (lambda (window)
      (gnc:main-window-open-report (gnc:make-welcome-report) window))))
)
