#
# Spec file for FC4
#
# Check whether GnuCash should build optional modules.
# To modify parameters, edit the .spec file, 0 is off, 1 is on
%define _with_postgres 0
%define _with_ofx 0
%define _with_hbci 0

%define fc_rel %(rpm -q --queryformat='%{VERSION}' fedora-release)
%define version 2.0.1
%define __libtoolize /bin/true

%define libgnomeui_version 2.8.0
%define libgnomeprintui_version 2.8.0
%define guile_version 1.6.0
%define gwrap_version 1.3.4
%define gtkhtml3_version 3.1
%define libofx_version 0.8.0
%define aqbanking_version 1.3
%define postgresql_version 7.1.3

Name:      	gnucash
Summary:   	GnuCash is an application to keep track of your finances.
Version:   	%{version}
Release:  	1.FC%{fc_rel}
License:	GPL
Group:     	Applications/Finance
URL:            http://www.gnucash.org
Source:    	http://www.gnucash.org/pub/gnucash/sources/stable/gnucash-%{version}.tar.gz
BuildRoot: 	%{_tmppath}/%{name}-%{version}-root

Prereq:         GConf2
Prereq:         /usr/bin/gconftool-2
Prereq: 	/sbin/ldconfig
PreReq:		/sbin/install-info

Requires:  	libgnomeui >= %{libgnomeui_version}
Requires:	libgnomeprintui22 >= %{libgnomeprintui22_version}
Requires:	guile >= %{guile_version}
Requires:	gtkhtml3 >= %{gtkhtml3_version}
Requires:	g-wrap >= %{g-wrap_version}

BuildRequires: 	libgnomeui-devel >= %{libgnomeui_version}
BuildRequires: 	libgnomeprintui22-devel >= %{libgnomeprintui22_version}
BuildRequires: 	g-wrap-devel >= %{g-wrap_version}
BuildRequires: 	gtkhtml3-devel >= %{gtkhtml3_version}
BuildRequires: 	bzip2-devel, expat-devel, guile-devel
BuildRequires: 	libglade2-devel, libgsf-devel
BuildRequires: 	libjpeg-devel, openssl-devel

%description
GnuCash is a personal finance manager. A check-book like
register GUI allows you to enter and track bank accounts,
stocks, income and even currency trades. The interface is
designed to be simple and easy to use, but is backed with
double-entry accounting principles to ensure balanced books.


%package devel
Summary: Header files for GnuCash development.
Group: Development/Libraries
Requires: gnucash = %{version}

%description devel
This package contains header files for GnuCash development.
Install this package if you want to use GnuCash libraries
in C programs.


%if %{_with_ofx}
%package ofx
Summary: Enables OFX importing in GnuCash
Group: Applications/Finance
Requires: gnucash = %{version}
Requires: libofx >= %{libofx_version}
BuildRequires: libofx

%description ofx
This package adds OFX file import support to the base
GnuCash package. Install this package if you want to
import OFX files.
%endif

%if %{_with_hbci}
%package hbci
Summary: Enables HBCI importing in GnuCash
Group: Applications/Finance
Requires: gnucash = %{version}
Requires: aqbanking >= %{aqbanking_version}
BuildRequires: aqbanking-devel

%description hbci
This package adds HBCI file import support to the base
GnuCash package. Install this package if you want to
import HBCI files.
%endif

%if %{_with_postgres}
%package backend-postgres
Summary: Backend for storing GnuCash data in a PostgreSQL database.
Group: Applications/Finance
Requires: gnucash = %{version}
Requires: postgresql >= %{postgresql_version}
BuildRequires: postgresql-devel

%description backend-postgres

This package contains a backend for storing your GnuCash accounts and
transactions in a PostgreSQL database.  Install this package if you
want to keep your financial data in a database instead of a flat file
(recommended for large volumes of data and commercial sites).
%endif


%prep
%setup -q

%build
%configure \
%if %{_with_ofx}
 --enable-ofx \
%endif
%if %{_with_hbci}
 --enable-hbci \
%endif
%if %{_with_postgres}
 --enable-sql \
%endif
 --enable-gui


make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

cp -p src/backend/postgres/README README.postgres

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
LIBRARY_PATH=$RPM_BUILD_ROOT%{_libdir}:$RPM_BUILD_ROOT%{_libdir}/gnucash make DESTDIR=$RPM_BUILD_ROOT install
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

%find_lang %name

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT/%{_infodir}/dir

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
/sbin/install-info %{_infodir}/gnucash-design.info.gz %{_infodir}/dir

export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS=%{_sysconfdir}/gconf/schemas/apps_gnucash*.schemas
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule $S > /dev/null
done

%preun
if [ "$1" -eq 0 ]; then
     #deleting the schema on package removal
     export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
     SCHEMAS=%{_sysconfdir}/gconf/schemas/apps_gnucash*.schemas
     for S in $SCHEMAS; do
       gconftool-2 --makefile-uninstall-rule $S > /dev/null
     done
fi

%postun
/sbin/ldconfig
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/gnucash-design.info.gz %{_infodir}/dir
fi

%files -f %{name}.lang
%defattr(444,root,root,755)
%attr(555,root,root) %{_bindir}/*
%attr(555,root,root) %{_libexecdir}/gnucash
%{_mandir}/man*/*
%{_infodir}/gnucash*info*
%{_libdir}/*
%{_datadir}/gnucash
%{_datadir}/applications/*
%{_datadir}/mime-info/gnucash.*
%{_datadir}/xml/gnucash/xsl/*
%{_sysconfdir}/gconf/schemas/apps_gnucash*
%if %{_with_ofx}
%exclude %{_libdir}/gnucash/libgncmod-ofx*
%endif
%if %{_with_hbci}
%exclude %{_libdir}/gnucash/libgncmod-hbci*
%exclude %{_datadir}/gnucash/glade/hbci*
%exclude %{_sysconfdir}/gconf/schemas/apps_gnucash_dialog_hbci.schemas
%endif
%if %{_with_postgres}
%exclude %{_libdir}/libgnc-backend-postgres*
%endif
%config %{_sysconfdir}/gnucash
%doc AUTHORS COPYING ChangeLog* DOCUMENTERS HACKING LICENSE NEWS README README.patches
%doc doc/README.german doc/README.francais doc/guile-hackers.txt

%files devel
%defattr(444,root,root,755)
%{_includedir}/gnucash
%{_datadir}/aclocal/gnucash.m4

%if %{_with_ofx}
%files ofx
%defattr(444,root,root,755)
%{_libdir}/gnucash/libgncmod-ofx*
%doc doc/README.OFX
%endif

%if %{_with_hbci}
%files hbci
%defattr(444,root,root,755)
%{_libdir}/gnucash/libgncmod-hbci*
%{_datadir}/gnucash/glade/hbci*
%{_sysconfdir}/gconf/schemas/apps_gnucash_dialog_hbci.schemas
%doc doc/README.HBCI
%endif

%if %{_with_postgres}
%files backend-postgres
%defattr(444,root,root,755)
%{_libdir}/libgnc-backend-postgres*
%doc README.postgres
%endif
