//  Gnomoradio - roboradio/song-list-library.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "song-list-library.h"
#include "song-rainbow.h"

using namespace Roboradio;
using namespace std;

Roboradio::SongListLibrary::SongListLibrary ()
	: SongListAutomatic("Local Music")
{
	construct();
	signal_removed.connect(sigc::mem_fun(*this, &SongListLibrary::on_remove));
}

Roboradio::SongListLibrary::~SongListLibrary ()
{
}

bool Roboradio::SongListLibrary::meets_criteria (const SongRef &song)
{
	return (dynamic_cast<SongLocal*>(&*song)
		&& !dynamic_cast<SongRainbow*>(&*song));
}

void Roboradio::SongListLibrary::on_remove (iterator song)
{
}
