// -*- c++ -*-

//  Gnomoradio - gnomoradio/intro-druid.h
//  Copyright (C) 2004  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __INTRO_DRUID_H
#define __INTRO_DRUID_H

#include "prefs-box.h"
#include "druid.h"

namespace Gnomoradio
{
	class IntroDruid : public PrefsBoxBase
	{
	public:
		IntroDruid ();
		virtual ~IntroDruid ();

		static void start_if_necessary ();

	private:
		void on_hide_window ();
		void on_finish ();
		void on_radio_list_enable_toggled ();

		Druid druid;

		static const int druid_version = 2;

		Gtk::SpinButton frequency;
		Gtk::CheckButton radio_enable_checkbutton;
	};
}

#endif
