//  Gnomoradio - roboradio/sort-songs.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "sort-songs.h"
#include <glibmm.h>

using namespace Roboradio;
using namespace Glib;
using namespace std;

auto_ptr<SortSongs::ContainerType> Roboradio::SortSongs::l[Types];
bool Roboradio::SortSongs::initialized = false;

namespace Roboradio
{
	class SongSortCriteria
	{
	public:
		bool operator () (const SongRef &x, const SongRef &y) const {
			return artist_or_title(x) < artist_or_title(y);
		}

	private:
		ustring artist_or_title (const SongRef s) const {
			ustring artist = s->get_info("artist");
			if (artist.size())
				return artist;
			else
				return s->get_info("title");
		}
	};
}

Roboradio::SortSongs::SortSongs (SortType type)
	: t(type)
{
	if (!&*l[t]) {
		auto_ptr<ContainerType> p(new ContainerType);
		l[t] = p;
		vector<SongRef> songs = Song::get_known_songs();
		for (vector<SongRef>::const_iterator i = songs.begin(); i != songs.end(); ++i)
			if ((*i)->get_status().available)
				l[t]->push_back(*i);
		l[t]->sort(SongSortCriteria());
	}

	if (!initialized) {
		Song::signal_global_new_song.connect(SigC::slot(&SortSongs::on_new_song));
		initialized = true;
	}
}

void Roboradio::SortSongs::on_new_song (SongRef song)
{
	for (int i = 0; i < Types; ++i)
		if (&*l[i])
			l[i]->push_back(song);
}

void Roboradio::SortSongs::on_song_changed (SongRef song)
{

}

// fixme: we need to keep track of unavailable songs to see if they
//        become available
