//  Gnomoradio - rainbow/alarm.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "rainbow/alarm.h"
#include <glibmm.h>

using namespace std;
using namespace SigC;

const int max_timeout = 3600; // in seconds

Rainbow::Alarm::Alarm ()
	: t(0)
{
}

Rainbow::Alarm::Alarm (time_t set_time)
	: t(0)
{
	set(set_time);
}

Rainbow::Alarm::~Alarm ()
{
}

void Rainbow::Alarm::set (time_t set_time)
{
	time_t current_time = time(0);
	if (current_time > set_time)
		signal();
	else {
		t = set_time;
		int timeout = 1000 * ((current_time + max_timeout < t) ? (max_timeout) : (t - current_time));
		Glib::signal_timeout().connect(SigC::slot(*this, &Alarm::timeout_handler), timeout);
	}
}

bool Rainbow::Alarm::timeout_handler ()
{
	if (t == 0) // alarm was reset
		return false;

	time_t current_time = time(0);
	if (current_time >= t) {
		t = 0;
		signal();
		return false;
	}

	// alarm has not expired yet
	if (current_time + max_timeout < t)
		return true;

	// alarm is about to expire
	Glib::signal_timeout().connect(SigC::slot(*this, &Alarm::timeout_handler), (t - current_time) * 1000);
	return false;
}
