#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <sane/sane.h>

int
main (int argc, char **argv)
{
  SANE_Status status;
  SANE_Handle handle;
  const SANE_Option_Descriptor *desc;
  SANE_Parameters parameters;
  const char * name = "plustek:libusb:003:002";
  unsigned char * buffer;
  int size, count, len;
  int brx,bry;

  GdkPixbuf *pixbuf;

  g_type_init ();

  sane_init (NULL, NULL);
  status = sane_open (name, &handle);

  if (status == SANE_STATUS_GOOD) {
#define BR_X	10
#define BR_Y	11

    desc = sane_get_option_descriptor (handle, BR_X);
    brx = SANE_FIX (215.0);
    g_debug ("option %s %x", desc->name, brx);
    sane_control_option (handle, BR_X, SANE_ACTION_SET_VALUE, &brx, NULL);

    desc = sane_get_option_descriptor (handle, BR_Y);
    bry = SANE_FIX (297.0);
    g_debug ("option %s %x", desc->name, bry);
    sane_control_option (handle, BR_Y, SANE_ACTION_SET_VALUE, &bry, NULL);

    sane_start (handle);
    sane_get_parameters (handle, &parameters);
    g_debug ("%ix%i", parameters.pixels_per_line, parameters.lines);
    size = parameters.lines * parameters.bytes_per_line;
    buffer = (unsigned char *) malloc (size);
    count = 0;
    do {
      status = sane_read (handle, buffer + count, size - count, &len);
      count+=len;
      g_debug ("Received %iB of %iB", count, size);
    } while (status == SANE_STATUS_GOOD);
    sane_cancel (handle);

    pixbuf = gdk_pixbuf_new_from_data (buffer, GDK_COLORSPACE_RGB, FALSE,
				       parameters.depth, parameters.pixels_per_line, parameters.lines, parameters.bytes_per_line,
				       NULL, NULL);
    gdk_pixbuf_save (pixbuf, "sane-test-ouput.png", "png", NULL, NULL);
  }

  sane_exit ();
  return (0);
}
