/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
using System;
using Gtk;
using Gdk;
using Mono.Unix;

namespace GnomeRDP
{
	public class SessionTreeStore : TreeStore
	{
		public SessionTreeStore() : base(typeof(Configuration))
		{
		}
		
		public TreeIter AppendValuesSession(Configuration config)
		{
			return this.AppendValues(config);
		}

		public TreeIter AppendValuesSession(TreeIter iter, Configuration config)
		{
			return this.AppendValues(iter, config);
		}		
	}
	
	public class SessionTreeView : TreeView
	{
		private Configuration _config = null;
		private bool _isCategory;
		public Configuration config
		{
			get {return _config;}
			set {_config=value;}
		}
		public bool IsCategory
		{
			get {return _isCategory;}
		}		
		
		public SessionTreeView(SessionTreeStore sessionTreeStore, bool isCategory) : base()
		{
			this._isCategory = isCategory;
			this.WidgetEvent += SessionTreeViewCursorChanged;
			this.Model = (Gtk.TreeModel)sessionTreeStore;
			
			Gtk.TreeViewColumn sessionNameColumn = new Gtk.TreeViewColumn();
			sessionNameColumn.Title = Catalog.GetString("Session name");
			Gtk.CellRendererPixbuf iconCell = new Gtk.CellRendererPixbuf();
			sessionNameColumn.PackStart(iconCell, false);
			sessionNameColumn.Resizable = true;
			Gtk.CellRendererText sessionNameCell = new Gtk.CellRendererText();
			sessionNameColumn.PackStart(sessionNameCell, false);
			
			if (!this._isCategory)
			{
				Gtk.TreeViewColumn computerColumn = new Gtk.TreeViewColumn();
				computerColumn.Title = Catalog.GetString("Computer");
				computerColumn.Resizable = true;
				Gtk.CellRendererText computerCell = new Gtk.CellRendererText();
				computerColumn.PackStart(computerCell, true);

				Gtk.TreeViewColumn protocolColumn = new Gtk.TreeViewColumn();
				protocolColumn.Title = Catalog.GetString("Protocol");
				protocolColumn.Resizable = true;
				Gtk.CellRendererText protocolCell = new Gtk.CellRendererText();
				protocolColumn.PackStart(protocolCell, true);

				Gtk.TreeViewColumn domainColumn = new Gtk.TreeViewColumn();
				domainColumn.Title = Catalog.GetString("Domain");
				domainColumn.Resizable = true;
				Gtk.CellRendererText domainCell = new Gtk.CellRendererText();
				domainColumn.PackStart(domainCell, true);

				Gtk.TreeViewColumn userNameColumn = new Gtk.TreeViewColumn();
				userNameColumn.Title = Catalog.GetString("Username");
				userNameColumn.Resizable = true;
				Gtk.CellRendererText userNameCell = new Gtk.CellRendererText();
				userNameColumn.PackStart(userNameCell, true);
				
				this.HeadersVisible = true;
				this.AppendColumn(sessionNameColumn);
				this.AppendColumn(computerColumn);
				this.AppendColumn(protocolColumn);
				this.AppendColumn(domainColumn);
				this.AppendColumn(userNameColumn);
				
				sessionNameColumn.SetCellDataFunc(iconCell, new Gtk.TreeCellDataFunc(RenderSessionIconTreeViewCell));
				sessionNameColumn.SetCellDataFunc(sessionNameCell, new Gtk.TreeCellDataFunc(RenderSessionTreeViewCell));
				computerColumn.SetCellDataFunc(computerCell, new Gtk.TreeCellDataFunc(RenderSessionTreeViewCell));
				protocolColumn.SetCellDataFunc(protocolCell, new Gtk.TreeCellDataFunc(RenderSessionTreeViewCell));
				domainColumn.SetCellDataFunc(domainCell, new Gtk.TreeCellDataFunc(RenderSessionTreeViewCell));
				userNameColumn.SetCellDataFunc(userNameCell, new Gtk.TreeCellDataFunc(RenderSessionTreeViewCell));							
			}
			else
			{
				this.HeadersVisible = false;
				this.AppendColumn(sessionNameColumn);
				sessionNameColumn.SetCellDataFunc(iconCell, new Gtk.TreeCellDataFunc(RenderSessionIconTreeViewCell));
				sessionNameColumn.SetCellDataFunc(sessionNameCell, new Gtk.TreeCellDataFunc(RenderSessionTreeViewCell));				
			}			
			this.RulesHint = true;			
		}

		private void RenderSessionIconTreeViewCell(Gtk.TreeViewColumn column, Gtk.CellRenderer cell, Gtk.TreeModel model, Gtk.TreeIter iter)
		{
			Configuration config = (Configuration)model.GetValue(iter, 0);
			switch (config.Protocol)
			{
				case 0:
					(cell as Gtk.CellRendererPixbuf).Pixbuf = Gdk.Pixbuf.LoadFromResource("rdp_16.png");
					break;
				case 1:
					(cell as Gtk.CellRendererPixbuf).Pixbuf = Gdk.Pixbuf.LoadFromResource("vnc_16.png");
					break;
				case 2:
					(cell as Gtk.CellRendererPixbuf).Pixbuf = Gdk.Pixbuf.LoadFromResource("ssh_16.png");
					break;
				default:
					(cell as Gtk.CellRendererPixbuf).Pixbuf = Gdk.Pixbuf.LoadFromResource("group_16.png");
					break;
			}
							
		}
		
		private void RenderSessionTreeViewCell(Gtk.TreeViewColumn column, Gtk.CellRenderer cell, Gtk.TreeModel model, Gtk.TreeIter iter)
		{
			Configuration config = (Configuration)model.GetValue(iter, 0);	
			if (column.Title == Catalog.GetString("Session name"))
			{
				(cell as Gtk.CellRendererText).Text = config.SessionName;
			}
			if (column.Title == Catalog.GetString("Computer"))
			{
				(cell as Gtk.CellRendererText).Text = config.Computer;
			}
			if (column.Title == Catalog.GetString("Protocol"))
			{
				switch (config.Protocol)
				{
					case 0:
						(cell as Gtk.CellRendererText).Text = Catalog.GetString("RDP");
						break;
					case 1:
						(cell as Gtk.CellRendererText).Text = Catalog.GetString("VNC");
						break;
					case 2:
						(cell as Gtk.CellRendererText).Text = Catalog.GetString("SSH");
						break;	
					default:
						(cell as Gtk.CellRendererText).Text = "";
						break;
				}
			}
			if (column.Title == Catalog.GetString("Domain"))
			{
				(cell as Gtk.CellRendererText).Text = config.Domain;
			}										
			if (column.Title == Catalog.GetString("Username"))
			{
				(cell as Gtk.CellRendererText).Text = config.User;
			}					
		}

		private void SessionTreeViewCursorChanged(object sender, EventArgs args)
		{
			TreeIter iter;
			try
			{
				TreeModel model = this.Model;
				if (this.Selection.GetSelected(out model, out iter))
				{
					Configuration config = (Configuration)model.GetValue(iter, 0);
					this._config = config;
				}
				else
				{
					this._config = null;
				}
			}
			catch
			{
				this._config = null;
			}
		}			
	}
}