/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
using System;
using Gtk;
using Glade;
using Vte;

namespace GnomeRDP
{
	public class TerminalDialog : GladeDialog
	{
		[Widget]VBox vbox11 = null;
		private Terminal term;
		
		public TerminalDialog() : base ("dlgTerminal")
		{
			term = new Terminal();
			term.CursorBlinks = true;
			term.ScrollOnOutput = true;
			term.MouseAutohide = true;
			term.ScrollOnKeystroke = true;
 			term.BackgroundTransparent = true;
 			//term.Encoding = "UTF-8";
			vbox11.PackStart(term);
			vbox11.ShowAll();
			//term.ChildExited += new EventHandler(OnChildExited);
		}
		
		public int Run(string cmd)
		{
			string[] argv = new string[] {""};
			string[] envv = {""};

			//int pid = 
			term.ForkCommand("bash \"mc\"", argv, envv, "/", false, true, true);
			int retval = this.Dialog.Run();
			this.Dialog.Destroy();
			return retval;
		}
		
	}
}
