Summary: GNOME Power Manager
Name: gnome-power-manager
Version: 0.2.8.1
Release: 1
License: GPL
Group: Applications/System
Source: gnome-power-manager-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://gnome-power.sourceforge.net/
BuildPrereq: libgnomeui-devel
BuildPrereq: libglade2-devel
BuildPrereq: libwnck-devel
BuildPrereq: hal-devel >= 0.5.4
BuildPrereq: dbus-devel >= 0.50
Requires: gnome-mime-data
Requires: gnome-icon-theme
Requires: libnotify >= 0.2.2
Requires: notification-daemon >= 0.2.2
Requires: hal >= 0.5.4
Requires: dbus-glib >= 0.50

%description
GNOME Power Manager uses the information and facilities provided by HAL 
displaying icons and handling user callbacks in an interactive GNOME session. 
GNOME Power Preferences allows authorised users to set policy and 
change preferences.

%prep
%setup -q

%build
%configure \
	--enable-libnotify					\
	--enable-doxygen-docs=no				\
	--prefix=%{buildroot}					\
	--with-doc-dir=%{buildroot}/usr/share/doc		\
	--with-dbus-sys=%{buildroot}/etc/dbus-1/system.d        \
	--with-dbus-services=%{buildroot}/usr/share/dbus-1/services
make

%install
rm -rf $RPM_BUILD_ROOT
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

desktop-file-install --vendor gnome --delete-original                   \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications                         \
  --add-only-show-in GNOME                                              \
  --add-category X-Red-Hat-Base                                         \
  $RPM_BUILD_ROOT%{_datadir}/applications/*

%find_lang %name

%clean
rm -rf $RPM_BUILD_ROOT

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
	%{_sysconfdir}/gconf/schemas/gnome-power-manager.schemas &>/dev/null
killall -HUP gconfd-2 || :

%preun
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-uninstall-rule \
        %{_sysconfdir}/gconf/schemas/gnome-power-manager.schemas &>/dev/null
killall -HUP gconfd-2 || :


%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING README
%{_bindir}/*
%{_datadir}/applications/*
%{_datadir}/dbus-1/*
%{_datadir}/gnome-power-manager
%{_datadir}/man/*
# TODO: remove system.d as g-p-m shouldn't be on the system bus
%{_sysconfdir}/dbus-1/system.d/*
%{_sysconfdir}/gconf/schemas/*.schemas

%changelog
* Fri Sep 02 2005 David Zeuthen <davidz@redhat.com> 0.2.3.1-1
- Initial import based on an SRPM from Richard Hughes

* Mon Jun 19 2005 Richard Hughes <richard@hughsie.com> 0.1.1-1
- New RPM version 0.1.1

* Mon Jun 18 2005 Richard Hughes <richard@hughsie.com> 0.1.0-1
- New RPM version 0.1.0

* Mon Jun 18 2005 Richard Hughes <richard@hughsie.com> 0.0.5-1
- New RPM version 0.0.5

%changelog
* Mon Apr 04 2005 Richard Hughes <richard@hughsie.com> 0.0.3-1
- initial packaging of 0.0.3


