/*
This file is part of Gnome Photo Printer.

    Gnome Photo Printer is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Gnome Photo Printer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Gnome Photo Printer; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GPP_H
#define GPP_H	1

#define	LAYOUT_1	1
#define LAYOUT_2	2
#define LAYOUT_3	3
#define	LAYOUT_4	4
#define LAYOUT_5	5
#define LAYOUT_6	6
#define LAYOUT_7	7
#define LAYOUT_8	8
#define LAYOUT_CUSTOM	9


#define PRINTER_DPI	72

enum
{
	PIXBUF_COLUMN,
	FILE_COLUMN,
	N_COLUMNS
};

GnomePrintConfig *gpp_config;
GnomePrintJob *gpp_job;
GnomePrintContext *gpp_context;

GtkSpinButton* gpp_custom_width;
GtkSpinButton* gpp_custom_height;

GtkWidget* gpp_pagesize;


typedef struct _print_definition
{
	gboolean to_file;
	gchar *output_file_name;

	gchar *paper_size;
	gdouble paper_size_x;
	gdouble paper_size_y;

	gint layout;
	gdouble layout_x;
	gdouble layout_y;

	gboolean image_scale_with_ratio;

	gint number_of_files;
	GtkListStore *file_names;
} *_gpp_definition;

_gpp_definition gpp_definition;

#endif
