/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* trayicon.h
 *
 * Copyright (C) 2006 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */

#ifndef __TRAYICON_H__
#define __TRAYICON_H__

#include <gnome.h>
#include <glade/glade.h>

#include "eggtrayicon.h"

class TrayIcon
{
public:
    TrayIcon (void);
    ~TrayIcon (void) {
		g_object_unref (xml);
    }

    gint getCount (void) { return count; };
    
private:

    void context_menu (void);

    static void destroyed_cb (GtkWidget *, gpointer);
    static void embedded_cb (GtkWidget *, gpointer);
    static void clicked_cb (GtkWidget *, GdkEventButton *, gpointer);

    static void play_cb (GtkWidget *, Channel *);
    static void info_cb (GtkWidget *, Channel *);
    static void url_cb (GtkWidget *, Channel *);
    static void bump_cb (GtkWidget *, Channel *);
    static void stop_cb (GtkWidget *, Channel *);
    
    void update_channel_list (void);
    void channel_submenu (GtkWidget *, Channel *);

    GtkWidget *getMenuItem (const gchar *name) {
	    return glade_xml_get_widget (xml, name); };
    
    void menuSignalConnect (const gchar *handler,
                            GCallback callback, gpointer data) {
	    glade_xml_signal_connect_data (xml, handler, callback, data);
    };

    gint count;

    EggTrayIcon *ticon;
    GtkWidget *image;    
    GladeXML *xml;
    GtkWidget *menu;
};

#endif
